package cn.easyutil.easyapi.filter.readInterface.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.readInterface.ReadInterfaceIgnore;

import java.lang.reflect.Method;

public class InterfaceIgnoreApiReader implements ReadInterfaceIgnore {
    @Override
    public Boolean ignore(Method method, ApiExtra extra) {
        ApidocComment apidocComment = method.getDeclaredAnnotation(ApidocComment.class);
        if(apidocComment != null){
            boolean hidden = apidocComment.hidden();
            if(hidden){
                return true;
            }
            return apidocComment.ignore();
        }
        return null;
    }
}
