package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.filter.readReq.*;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

@Component
@ConfigurationProperties(prefix = "easyapi.filter.request")
public class EasyApiFilterRequestConfiguration {

    /** 读取请求参数断言表达式*/
    private Set<Class<ReadRequestCondition>> conditions = new HashSet<>();

    /** 读取请求参数说明*/
    private Set<Class<ReadRequestDescription>> descriptions = new HashSet<>();

    /** 读取请求参数忽略配置*/
    private Set<Class<ReadRequestIgnore>> ignore = new HashSet<>();

    /** 读取请求参数mock模板*/
    private Set<Class<ReadRequestMockTemplate>> mockTemplate = new HashSet<>();

    /** 读取请求参数名称*/
    private Set<Class<ReadRequestName>> name = new HashSet<>();

    /** 读取全部请求参数*/
    private Set<Class<ReadRequestParams>> params = new HashSet<>();

    /** 读取请求参数必填配置*/
    private Set<Class<ReadRequestRequired>> required = new HashSet<>();

    /** 读取请求参数显示隐藏配置*/
    private Set<Class<ReadRequestShow>> show = new HashSet<>();

    /** 读取请求参数类型*/
    private Set<Class<ReadRequestType>> type = new HashSet<>();

    public Set<Class<ReadRequestCondition>> getConditions() {
        return conditions;
    }

    public void setConditions(Set<Class<ReadRequestCondition>> conditions) {
        this.conditions = conditions;
    }

    public Set<Class<ReadRequestDescription>> getDescriptions() {
        return descriptions;
    }

    public void setDescriptions(Set<Class<ReadRequestDescription>> descriptions) {
        this.descriptions = descriptions;
    }

    public Set<Class<ReadRequestIgnore>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<ReadRequestIgnore>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<ReadRequestMockTemplate>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(Set<Class<ReadRequestMockTemplate>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public Set<Class<ReadRequestName>> getName() {
        return name;
    }

    public void setName(Set<Class<ReadRequestName>> name) {
        this.name = name;
    }

    public Set<Class<ReadRequestParams>> getParams() {
        return params;
    }

    public void setParams(Set<Class<ReadRequestParams>> params) {
        this.params = params;
    }

    public Set<Class<ReadRequestRequired>> getRequired() {
        return required;
    }

    public void setRequired(Set<Class<ReadRequestRequired>> required) {
        this.required = required;
    }

    public Set<Class<ReadRequestShow>> getShow() {
        return show;
    }

    public void setShow(Set<Class<ReadRequestShow>> show) {
        this.show = show;
    }

    public Set<Class<ReadRequestType>> getType() {
        return type;
    }

    public void setType(Set<Class<ReadRequestType>> type) {
        this.type = type;
    }
}
