package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.EasyapiRun;
import cn.easyutil.easyapi.filter.config.*;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import javax.annotation.Resource;
import java.util.ArrayList;

@Configuration
@Import({EasyApiBaseConfiguration.class
        , EasyApiDataConfiguration.class
        , EasyApiUserConfiguration.class
        , EasyApiFilterBeanConfiguration.class
        , EasyApiFilterControllerConfiguration.class
        , EasyApiFilterInterfaceConfiguration.class
        , EasyApiFilterMockConfiguration.class
        , EasyApiFilterRequestConfiguration.class
        , EasyApiFilterResponseConfiguration.class
        ,SpringRunEnvClassComponent.class})
@ConditionalOnMissingBean(AbstractConfigurationCreator.class)
@ConditionalOnProperty(prefix = "easyapi",name = "enable",havingValue = "true")
public class EasyApiAutoConfiguration implements InitializingBean {

    @Resource
    private EasyApiBaseConfiguration configuration;
    @Resource
    private EasyApiDataConfiguration dataConfiguration;
    @Resource
    private EasyApiUserConfiguration userConfiguration;
    @Resource
    private EasyApiFilterBeanConfiguration filterBeanConfiguration;
    @Resource
    private EasyApiFilterControllerConfiguration filterControllerConfiguration;
    @Resource
    private EasyApiFilterInterfaceConfiguration filterInterfaceConfiguration;
    @Resource
    private EasyApiFilterMockConfiguration filterMockConfiguration;
    @Resource
    private EasyApiFilterRequestConfiguration filterRequestConfiguration;
    @Resource
    private EasyApiFilterResponseConfiguration filterResponseConfiguration;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void afterPropertiesSet(){
        AllConfiguration all = new AllConfiguration();
        all.setConfiguration(configuration);
        all.setDataConfiguration(dataConfiguration);
        all.setUserConfiguration(userConfiguration);
        all.setReadResponseConfig(filterResponseConfiguration);
        all.setReadRequestConfig(filterRequestConfiguration);
        all.setReadMockTemplateConfig(filterMockConfiguration);
        all.setReadInterfaceConfig(filterInterfaceConfiguration);
        all.setReadControllerConfig(filterControllerConfiguration);
        all.setReadBeanConfig(filterBeanConfiguration);
        //生成接口文档
        EasyapiRun.run(all,applicationContext);
    }
}
