/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import cn.easyutil.easyapi.handler.operator.provide.ControllerReaderProvider;
import cn.easyutil.easyapi.util.StringUtil;

public class ControllerCreator {
    private Class clazz;
    private DBModuleControllerEntity controllerBean;
    private ControllerReaderProvider filter = new ControllerReaderProvider();
    private ControllerExtra extra;

    private ControllerCreator() {
    }

    public static ControllerCreator builder(Class clazz) {
        ControllerCreator creator = new ControllerCreator();
        creator.clazz = clazz;
        return creator;
    }

    public ControllerCreator setFilter(ControllerReaderProvider filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public ControllerCreator setExtra(ControllerExtra extra) {
        this.extra = extra;
        return this;
    }

    public DBModuleControllerEntity buildController() {
        if (this.controllerBean != null) {
            return this.controllerBean;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            throw new ApidocException("\u521b\u5efacontroller:" + this.clazz.getCanonicalName() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
        }
        return this.controllerBean;
    }

    private void create() {
        this.controllerBean = new DBModuleControllerEntity();
        this.controllerBean.setShowName(this.filter.name(this.extra, null));
        if (StringUtil.isEmpty(this.controllerBean.getShowName())) {
            this.controllerBean.setShowName(this.clazz.getSimpleName());
        }
        this.controllerBean.setShowName(this.controllerBean.getShowName().trim());
        this.controllerBean.setShow(this.filter.show(this.extra, null) != false ? 1 : 0);
        this.controllerBean.setApiPath(this.filter.path(this.extra, null));
        this.controllerBean.setClassName(this.clazz.getCanonicalName());
        this.controllerBean.setPinyin(StringUtil.toPinYin(this.controllerBean.getShowName()).trim());
        this.controllerBean.setDescription(this.filter.description(this.extra, null));
        this.controllerBean.setAuthor(this.filter.author(this.extra, null));
        this.controllerBean.setSource(this.extra.getControllerComment().getSource());
        this.controllerBean.setSearchTags(DBModuleControllerEntity.buildSearchTag(this.controllerBean).trim());
    }
}

