/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.condition;

import java.lang.annotation.Annotation;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Email;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;

public enum ConstraintEnums {
    max(Max.class){

        @Override
        public String parseToEl(Annotation annotation) {
            Max max = (Max)annotation;
            return this.getElThis().append("<=").append(max.value()).toString();
        }
    }
    ,
    min(Min.class){

        @Override
        public String parseToEl(Annotation annotation) {
            Min min = (Min)annotation;
            return this.getElThis().append(">=").append(min.value()).toString();
        }
    }
    ,
    size(Size.class){

        @Override
        public String parseToEl(Annotation annotation) {
            Size size = (Size)annotation;
            return this.getElThis().append(">=").append(size.min()).append("&&").append(this.getElThis()).append("<=").append(size.max()).toString();
        }
    }
    ,
    decimalMax(DecimalMax.class){

        @Override
        public String parseToEl(Annotation annotation) {
            DecimalMax max = (DecimalMax)annotation;
            return this.getElThis().append("<=").append(max.value()).toString();
        }
    }
    ,
    negative(Negative.class){

        @Override
        public String parseToEl(Annotation annotation) {
            return this.getElThis().append("<0").toString();
        }
    }
    ,
    negativeOrZero(NegativeOrZero.class){

        @Override
        public String parseToEl(Annotation annotation) {
            return this.getElThis().append("<=0").toString();
        }
    }
    ,
    notNull(NotNull.class){

        @Override
        public String parseToEl(Annotation annotation) {
            return this.getElThis().append("!=null").toString();
        }
    }
    ,
    notEmpty(NotEmpty.class){

        @Override
        public String parseToEl(Annotation annotation) {
            return "@notEmpty(" + this.getElThis() + ")";
        }
    }
    ,
    notBlank(NotBlank.class){

        @Override
        public String parseToEl(Annotation annotation) {
            return notEmpty.parseToEl(annotation);
        }
    }
    ,
    assertTure(AssertTrue.class){

        @Override
        public String parseToEl(Annotation annotation) {
            return this.getElThis().append("==true").toString();
        }
    }
    ,
    assertFalse(AssertFalse.class){

        @Override
        public String parseToEl(Annotation annotation) {
            return this.getElThis().append("==false").toString();
        }
    }
    ,
    pattern(Pattern.class){

        @Override
        public String parseToEl(Annotation annotation) {
            Pattern pattern = (Pattern)annotation;
            String regexp = pattern.regexp();
            return this.getElThis() + " matches '" + regexp + "'";
        }
    }
    ,
    digits(Digits.class),
    email(Email.class),
    future(Future.class),
    futureOrPresent(FutureOrPresent.class),
    past(Past.class),
    pastOrPresent(PastOrPresent.class),
    positive(Positive.class),
    positiveOrZero(PositiveOrZero.class),
    _null(Null.class);

    private Class annotationClass;

    private ConstraintEnums(Class annotationClass) {
        this.annotationClass = annotationClass;
    }

    public static String getElString(Annotation annotation) {
        ConstraintEnums[] values;
        if (annotation == null) {
            return "";
        }
        for (ConstraintEnums value : values = ConstraintEnums.values()) {
            if (!value.getAnnotationClass().isAssignableFrom(annotation.getClass())) continue;
            return value.parseToEl(annotation);
        }
        return "";
    }

    public String parseToEl(Annotation annotation) {
        return "";
    }

    protected StringBuffer getElThis() {
        StringBuffer sb = new StringBuffer();
        sb.append("$(current.val)");
        return sb;
    }

    public Class getAnnotationClass() {
        return this.annotationClass;
    }
}

