/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.javadoc.html;

import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.mybatis.service.ArticleService;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.OutPackageService;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.mybatis.service.SimpleUnitService;
import cn.easyutil.easyapi.mybatis.service.UserService;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ZipUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class StaticDocCreate {
    private final UserService userService = new UserService();
    private final ControllerService controllerService = new ControllerService();
    private final InterfaceService interfaceService = new InterfaceService();
    private final InterfaceParamService paramService = new InterfaceParamService();
    private final SimpleUnitService unitService = new SimpleUnitService();
    private final ProjectService projectService = new ProjectService();
    private final OutPackageService outPackageService = new OutPackageService();
    private final ArticleService articleService = new ArticleService();
    private static final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(HttpServletResponse response, DBProjectEntity project) throws UnsupportedEncodingException {
        String basePath = project.getProjectName() + "-static-api";
        File zipFile = new File(basePath + "-api.zip");
        File root = null;
        if (!zipFile.exists()) {
            StaticDocCreate staticDocCreate = this;
            synchronized (staticDocCreate) {
                if (!zipFile.exists()) {
                    root = this.createApiFolder(basePath, project.getId());
                    this.toZip(basePath, zipFile);
                }
            }
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(project.getProjectName() + "-apidoc.zip", "utf-8"));
        try (FileInputStream in = new FileInputStream(zipFile);){
            int length;
            byte[] but = new byte[0x100000];
            while ((length = in.read(but)) != -1) {
                response.getOutputStream().write(but, 0, length);
                response.getOutputStream().flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.deepDelFile(zipFile);
        if (root != null) {
            this.deepDelFile(root);
        }
    }

    private void deepDelFile(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                file.delete();
            } else {
                Stream.of(files).forEach(this::deepDelFile);
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    private File createApiFolder(String basePath, Long projectId) {
        File root = new File(basePath);
        root.delete();
        root.mkdirs();
        this.createBaseFiles(basePath);
        try {
            this.createStaticData(basePath, projectId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    private void createBaseFiles(String basePath) {
        this.saveFile(basePath, resolver.getResource("classpath:static/apidoc.html"));
        this.saveFile(basePath, resolver.getResource("classpath:static/logo.png"));
        String cssPath = basePath + File.separator + "css";
        new File(cssPath).mkdirs();
        this.savePattenFiles(cssPath, "classpath:static/css/**.css");
        String fontPath = basePath + File.separator + "fonts";
        new File(fontPath).mkdirs();
        this.savePattenFiles(fontPath, "classpath:static/fonts/**");
        String imgPath = basePath + File.separator + "img";
        new File(imgPath).mkdirs();
        this.savePattenFiles(imgPath, "classpath:static/img/**.png");
        String jsPath = basePath + File.separator + "js";
        new File(jsPath).mkdirs();
        this.savePattenFiles(jsPath, "classpath:static/js/**.js");
    }

    private void createStaticData(String basePath, Long projectId) throws Exception {
        File dataFile = new File(basePath + File.separator + "StaticData.js");
        List users = this.userService.list();
        List controllers = this.controllerService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).eq(DBModuleControllerEntity::getShow, (Object)1)).eq(BaseDbEntity::getProjectId, (Object)projectId)).orderByAsc(DBModuleControllerEntity::getSort)).orderByAsc(DBModuleControllerEntity::getPinyin));
        ArrayList<FindControllerAndInterfaceVo> controllerVos = new ArrayList<FindControllerAndInterfaceVo>();
        if (controllers != null && !controllers.isEmpty()) {
            for (DBModuleControllerEntity controller : controllers) {
                FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
                BeanUtils.copyProperties((Object)controller, (Object)vo);
                DBModuleInterfaceEntity queryIn = new DBModuleInterfaceEntity();
                queryIn.setControllerId(controller.getId());
                vo.setChildren(Optional.ofNullable(this.interfaceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)queryIn).eq(DBModuleInterfaceEntity::getShowType, (Object)1)).eq(BaseDbEntity::getProjectId, (Object)projectId)).orderByAsc(DBModuleInterfaceEntity::getSort)).orderByAsc(DBModuleInterfaceEntity::getPinyin))).orElse(Collections.emptyList()));
                controllerVos.add(vo);
            }
        }
        List interfaces = this.interfaceService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(DBModuleInterfaceEntity::getShowType, (Object)1)).eq(BaseDbEntity::getProjectId, (Object)projectId)).orderByAsc(DBModuleInterfaceEntity::getSort)).orderByAsc(DBModuleInterfaceEntity::getPinyin));
        List params = this.paramService.list((Wrapper)Wrappers.lambdaQuery(DBInterfaceParamEntity.class).eq(BaseDbEntity::getProjectId, (Object)projectId));
        List units = this.unitService.list((Wrapper)Wrappers.lambdaQuery(DBSimpleUnitEntity.class).eq(BaseDbEntity::getProjectId, (Object)projectId));
        List packages = this.outPackageService.list((Wrapper)Wrappers.lambdaQuery(DBModuleOutPackageEntity.class).eq(BaseDbEntity::getProjectId, (Object)projectId));
        List articles = this.articleService.list((Wrapper)Wrappers.lambdaQuery(DBArticleEntity.class).eq(BaseDbEntity::getProjectId, (Object)projectId));
        DBProjectEntity project = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery(DBProjectEntity.class).eq(BaseDbEntity::getId, (Object)projectId));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dataFile)));
        writer.write("var ApiProfile = {");
        writer.newLine();
        writer.write("isStatic: true,");
        writer.newLine();
        writer.write("project: " + JsonUtil.beanToJson(project) + ",");
        writer.newLine();
        writer.write("userList: " + JsonUtil.beanToJson(users) + ",");
        writer.newLine();
        writer.write("controllerList: " + JsonUtil.beanToJson(controllerVos) + ",");
        writer.newLine();
        writer.write("interfaceList: " + JsonUtil.beanToJson(interfaces) + ",");
        writer.newLine();
        writer.write("paramList: " + JsonUtil.beanToJson(params) + ",");
        writer.newLine();
        writer.write("unitList: " + JsonUtil.beanToJson(units) + ",");
        writer.newLine();
        writer.write("paramPackages: " + JsonUtil.beanToJson(packages) + ",");
        writer.newLine();
        writer.write("articles: " + JsonUtil.beanToJson(articles) + ",");
        writer.newLine();
        writer.write("}");
        writer.flush();
        writer.close();
    }

    private void saveFile(String basePath, Resource resource) {
        String filename = basePath + File.separator + resource.getFilename();
        try (InputStream inputStream = resource.getInputStream();){
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(new File(filename)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void savePattenFiles(String basePath, String patten) {
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources(patten)) {
                this.saveFile(basePath, resource);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void toZip(String folderPath, File zipFile) {
        try (FileOutputStream fos1 = new FileOutputStream(zipFile);){
            ZipUtil.toZip(folderPath, fos1, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

