/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.dto.DoSimpleUnitDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.DoSimpleUnitVo;
import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.SimpleUnitService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiUnitController"})
@RequestMapping(value={"/easyapi/doc/unit"})
public class UnitController {
    private final SimpleUnitService simpleUnitService = new SimpleUnitService();
    private final InterfaceService interfaceService = new InterfaceService();

    @ApidocComment(value="\u4fdd\u5b58\u6d4b\u8bd5\u8bb0\u5f55")
    @PostMapping(value={"/saveUnit"})
    @AccessAuth(code=1000)
    public void saveUnit(@RequestBody DBSimpleUnitEntity entity) {
        AssertUtil.isNull((Object)entity.getInterfaceUnique(), "\u672a\u77e5\u63a5\u53e3");
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setType(1);
        this.simpleUnitService.save(entity);
    }

    @ApidocComment(value="\u83b7\u53d6\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2\u8bb0\u5f55")
    @AccessAuth(code=1000)
    public List<DBSimpleUnitEntity> getAllUnit(@RequestBody DBSimpleUnitEntity dto) {
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceUnique(dto.getInterfaceUnique());
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        return this.simpleUnitService.list((Wrapper)Wrappers.lambdaQuery((Object)unit).orderByDesc(BaseDbEntity::getCreateTime));
    }

    @ApidocComment(value="\u83b7\u53d6\u4e0a\u6b21\u63a5\u53e3\u6267\u884c\u76f8\u5173\u53c2\u6570")
    @AccessAuth(code=1000)
    public DBSimpleUnitEntity getLastUnit(@RequestBody DBSimpleUnitEntity dto) {
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceUnique(dto.getInterfaceUnique());
        unit.setType(0);
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        return (DBSimpleUnitEntity)this.simpleUnitService.getOne((Wrapper)Wrappers.lambdaQuery((Object)unit), false);
    }

    @ApidocComment(value="\u4fee\u6539\u6267\u884c\u7ed3\u679c")
    @AccessAuth(code=1000)
    public void updateUnit(@RequestBody DBSimpleUnitEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u7f3a\u5c11id");
        this.simpleUnitService.updateById(entity);
    }

    @ApidocComment(value="\u5220\u9664\u6d4b\u8bd5\u8bb0\u5f55")
    @AccessAuth(code=1000)
    public void delUnit(@RequestBody IdDto dto) {
        this.simpleUnitService.removeById(dto.getId());
    }

    @ApidocComment(value="\u6267\u884c\u7f51\u7edc\u8bf7\u6c42")
    @AccessAuth(code=1000)
    public DoSimpleUnitVo doSimpleUnit(@RequestBody DoSimpleUnitDto entity) {
        Long userId = CurrentSession.getCurrentUser().getId();
        Long interfaceId = entity.getInterfaceId();
        String jsonParams = entity.getSaveParamsJson();
        String jsonHeaders = entity.getSaveHeadersJson();
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        DBModuleInterfaceEntity info = (DBModuleInterfaceEntity)this.interfaceService.getById(interfaceId);
        unit.setInterfaceUnique(info.getInterfaceUnique());
        unit.setUserId(userId);
        unit.setType(0);
        this.simpleUnitService.remove((Wrapper)Wrappers.lambdaQuery((Object)unit));
        unit.setName("LATEST");
        unit.setRequestUrl(entity.getSaveUrl());
        unit.setJsonHeaders(jsonHeaders);
        unit.setJsonParameters(jsonParams);
        unit.setUseStyleType(entity.getUseStyleType());
        unit.setJsonPackages(entity.getSavePackageJson());
        unit.setJsonTables(entity.getSaveTableJson());
        unit.setJsonPreScripts(entity.getSavePreScripts() == null ? "[]" : entity.getSavePreScripts());
        unit.setJsonPostScripts(entity.getSavePostScripts() == null ? "[]" : entity.getSavePostScripts());
        this.simpleUnitService.save(unit);
        long startTime = System.currentTimeMillis();
        HttpRes httpRes = ComplexTestProcess.doUrl(entity, true);
        long endTime = System.currentTimeMillis();
        httpRes.getResponseMsg();
        String responseMsg = httpRes.getResponseMsg();
        unit.setJsonResponse(responseMsg);
        unit.setJsonResHeaders(JsonUtil.beanToJson(httpRes.getResponseHeaders()));
        unit.setAnswerTime(endTime - startTime);
        DoSimpleUnitVo result = new DoSimpleUnitVo();
        result.setResponseCode(httpRes.getResponseCode());
        result.setResponseMsg(httpRes.getResponseMsg());
        if (JsonUtil.isJson(httpRes.getResponseMsg())) {
            try {
                Map<String, Object> map = JsonUtil.jsonToMap(httpRes.getResponseMsg());
                result.setResponseMsg(map);
            }
            catch (Exception e) {
                result.setResponseMsg(httpRes.getResponseMsg());
            }
        }
        result.setResponseHeaders(httpRes.getResponseHeaders());
        result.setAnswerTime(endTime - startTime);
        result.setUnitId(unit.getId());
        result.setResponseBase64(httpRes.getResponseBase64());
        unit.setJsonResponse(httpRes.getResponseMsg());
        unit.setResponseBase64(result.getResponseBase64());
        this.simpleUnitService.updateById(unit);
        return result;
    }
}

