/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class InterfaceDescSwaggerReader
extends HandlerChain<InterfaceExtra, String> {
    @Override
    public String resolve(InterfaceExtra extra, String transfer) {
        if (!StringUtil.isEmpty(transfer)) {
            return this.nextHandler().resolve(extra, transfer);
        }
        Method method = extra.getMethod();
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiParam", method.getAnnotations());
        if (annotation == null) {
            return this.nextHandler().resolve(extra, transfer);
        }
        Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
        if (!StringUtil.isEmpty(value)) {
            return this.nextHandler().resolve(extra, (String)value);
        }
        Annotation apiOperation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiOperation", method.getAnnotations());
        if (apiOperation == null) {
            return this.nextHandler().resolve(extra, transfer);
        }
        Object notes = AnnotationUtil.getAnnotationValue(apiOperation, "notes");
        if (!StringUtil.isEmpty(notes)) {
            return this.nextHandler().resolve(extra, (String)notes);
        }
        Object tags = AnnotationUtil.getAnnotationValue(apiOperation, "tags");
        if (tags == null) {
            return this.nextHandler().resolve(extra, transfer);
        }
        String[] tgs = (String[])tags;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tgs.length; ++i) {
            sb.append(i).append(1).append(":").append(tgs[i]).append(".");
        }
        return this.nextHandler().resolve(extra, sb.toString());
    }
}

