package cn.easyutil.easyapi.util;

import cn.easyutil.easyapi.entity.common.EasyapiOrigin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EasyapiOriginUtil {

    /**
     * 创建原始数据
     */
    public static <T> String createOrigin(T t){
        Class<?> tClass = t.getClass();
        Map<String, EasyapiOrigin> fieldAnnotation = ObjectUtil.getFieldAnnotation(tClass, EasyapiOrigin.class);
        if(fieldAnnotation.isEmpty()){
            return "";
        }
        Set<String> keys = fieldAnnotation.keySet();
        Map<String,Object> origin = new HashMap<>();
        for (String key : keys) {
            Object val = ObjectUtil.getAttributeValue(t, key);
            origin.put(key,val);
        }
        return JsonUtil.beanToJson(origin);
    }

    /**
     * 合并数据
     * @param now   当前生成的数据
     * @param old   之前存在的数据
     * @param origin    原始数据
     */
    public static <T> void mergin(T now,T old,T origin){
        Class<?> tClass = now.getClass();
        Map<String, EasyapiOrigin> fieldAnnotation = ObjectUtil.getFieldAnnotation(tClass, EasyapiOrigin.class);
        if(fieldAnnotation.isEmpty()){
            return ;
        }
        Set<String> keys = fieldAnnotation.keySet();
        for (String key : keys) {
            Object nowVal = ObjectUtil.getAttributeValue(now, key);
            Object oldVal = ObjectUtil.getAttributeValue(old, key);
            Object originVal = ObjectUtil.getAttributeValue(origin, key);
            if(oldVal!=null && !oldVal.equals(originVal)){
                //如果旧的数据跟原始数据不一致，说明被手动改动过了，新生成的数据不能覆盖被改动过的
                ObjectUtil.setAttribute(now,key,oldVal);
            }
            if(nowVal!=null && !nowVal.equals(originVal)){
                //如果当前生成的数据跟原始数据不一致，则将原始数据改掉
                ObjectUtil.setAttribute(origin,key,nowVal);
            }
        }
    }
}
