package cn.easyutil.easyapi.mybatis.service;

import cn.easyutil.easyapi.entity.db.auth.DBDictEntity;
import cn.easyutil.easyapi.mybatis.BaseService;
import cn.easyutil.easyapi.mybatis.MybatisUtil;
import cn.easyutil.easyapi.mybatis.mapper.DictMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.apache.commons.codec.Charsets;

import java.nio.charset.Charset;

public class DictService extends BaseService<DictMapper, DBDictEntity> {
    @Override
    public DictMapper getMapper() {
        return MybatisUtil.getMapper(DictMapper.class);
    }

    public DBDictEntity getByKey(String key){
        DBDictEntity entity = new DBDictEntity();
        entity.setDictKey(key);
        return getOne(Wrappers.lambdaQuery(entity),false);
    }

    public void updateByKey(String key,String val){
        update(Wrappers.lambdaUpdate(DBDictEntity.class).set(DBDictEntity::getDictValBytes,val.getBytes(Charsets.UTF_8)).eq(DBDictEntity::getDictKey,key));
    }
}
