package cn.easyutil.easyapi.mybatis;

import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.Collection;

public abstract class BaseService<M extends IBaseMapper<T>, T extends BaseDbEntity> extends ServiceImpl<M, T> implements GetMainMapper<M> {

    public BaseService() {
        this.baseMapper = getMapper();
    }

    @Override
    public boolean saveBatch(Collection<T> entityList) {
        for (T t : entityList) {
            t.setCreateTime(System.currentTimeMillis());
        }
        return super.saveBatch(entityList);
    }

    @Override
    public boolean save(T entity) {
        entity.setCreateTime(System.currentTimeMillis());
        return super.save(entity);
    }
}
