package cn.easyutil.easyapi.handler.reader.requests.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.util.StringUtil;

public class RequestMockTemplateCommentReader extends HandlerChain<RequestExtra,String> {

    @Override
    public String resolve(RequestExtra extra, String transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        if(extra.getParameter() == null){
            return nextHandler().resolve(extra, transfer);
        }
        MethodComment methodComment = extra.getInterfaceExtra().getMethodComment();
        String template = CreatorCommonMethod.mockTemplate(extra.getParameter().getAnnotations());
        if(StringUtil.isEmpty(template)){
            if(methodComment!=null && !StringUtil.isEmpty(extra.getParameterName()) && methodComment.getParameter(extra.getParameterName())!=null){
                //从注释中获取
                String mockValue = ApidocCommentUtil.getCommentValue(methodComment.getParameter(extra.getParameterName()).getComment(), "mockValue");
                if(StringUtil.isEmpty(mockValue)){
                    return nextHandler().resolve(extra, transfer);
                }
                return nextHandler().resolve(extra, mockValue);
            }
        }
        return nextHandler().resolve(extra, transfer);
    }
}
