package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.util.StringUtil;

public class InterfaceShowNameCommentReader extends HandlerChain<InterfaceExtra,String> {

    @Override
    public String resolve(InterfaceExtra extra, String transfer) {
        if(extra.getMethodComment()!=null && !StringUtil.isEmpty(extra.getMethodComment().getComment())){
            String value = ApidocCommentUtil.getCommentValue(extra.getMethodComment().getComment(), null);
            if(!StringUtil.isEmpty(value)){
                return nextHandler().resolve(extra, value);
            }
            return nextHandler().resolve(extra, ApidocCommentUtil.clearComment(extra.getMethodComment().getComment()));
        }
        return nextHandler().resolve(extra, transfer);
    }
}
