package cn.easyutil.easyapi.handler.reader.interfaces;

import cn.easyutil.easyapi.handler.reader.interfaces.model.*;

public class DefaultInterfaceReaderHandler {

    public void addDefault(){
        bodyTypes();
        descriptions();
        ignores();
        requestMethods();
        urls();
        scans();
        shows();
        names();
        uniques();
    }

    private void bodyTypes(){
        InterfaceReaderHandler.addBodyTypeHandlers(new InterfaceBodyTypeCommentReader());
    }

    private void descriptions(){
        InterfaceReaderHandler.addDescriptionHandlers(new InterfaceDescApiReader());
        InterfaceReaderHandler.addDescriptionHandlers(new InterfaceDescSwaggerReader());
        InterfaceReaderHandler.addDescriptionHandlers(new InterfaceDescCommentReader());
    }

    private void ignores(){
        InterfaceReaderHandler.addIgnoreHandlers(new InterfaceIgnoreApiReader());
        InterfaceReaderHandler.addIgnoreHandlers(new InterfaceIgnoreSwaggerReader());
        InterfaceReaderHandler.addIgnoreHandlers(new InterfaceIgnoreCommentReader());
    }

    private void requestMethods(){
        InterfaceReaderHandler.addRequestMethodHandlers(new InterfaceRequestMethodCommentReader());
    }

    private void urls(){
        InterfaceReaderHandler.addUrlHandlers(new InterfaceRequestUrlCommentReader());
    }

    private void scans(){
        InterfaceReaderHandler.addScanHandlers(new InterfacesCommentReader());
    }

    private void shows(){
        InterfaceReaderHandler.addShowHandlers(new InterfaceShowApiReader());
        InterfaceReaderHandler.addShowHandlers(new InterfaceShowCommentReader());
    }

    private void names(){
        InterfaceReaderHandler.addNameHandlers(new InterfaceShowNameApiReader());
        InterfaceReaderHandler.addNameHandlers(new InterfaceShowNameSwaggerReader());
        InterfaceReaderHandler.addNameHandlers(new InterfaceShowNameCommentReader());
    }

    private void uniques(){
        InterfaceReaderHandler.addUniqueHandlers(new InterfaceUniqueCommentReader());
    }
}
