package cn.easyutil.easyapi.handler.reader.controllers.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import cn.easyutil.easyapi.util.StringUtil;

public class ControllerShowNameCommentReader extends HandlerChain<ControllerExtra,String> {

    @Override
    public String resolve(ControllerExtra extra, String transfer) {
        if(extra.getControllerComment()==null || !StringUtil.isEmpty(transfer)){
            return nextHandler().resolve(extra, transfer);
        }
        String commentValue = ApidocCommentUtil.getCommentValue(extra.getControllerComment().getComment(), null);
        if(!StringUtil.isEmpty(commentValue)){
            return nextHandler().resolve(extra, commentValue);
        }
        String cmt = ApidocCommentUtil.clearComment(extra.getControllerComment().getComment());
        return nextHandler().resolve(extra, cmt);
    }
}
