package cn.easyutil.easyapi.handler.reader.controllers.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.BaseExtra;
import org.springframework.stereotype.Controller;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ControllerScanCommonReader extends HandlerChain<BaseExtra, Set<Class>> {

    @Override
    public Set<Class> resolve(BaseExtra extra, Set<Class> transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        Map<String, Object> beansWithAnnotation = extra.getAppContext().getBeansWithAnnotation(Controller.class);
        Set<Class> set = new HashSet<>();
        Iterator<Map.Entry<String, Object>> iterator = beansWithAnnotation.entrySet().iterator();
        while (iterator.hasNext()){
            Map.Entry<String, Object> next = iterator.next();
            Object value = next.getValue();
            Class<?> aClass = value.getClass();
            if(aClass.getCanonicalName().contains("cn.easyutil.easyapi")){
                continue;
            }
            if(aClass.getCanonicalName().contains("$$")){
                set.add(aClass.getSuperclass());
                continue;
            }
            set.add(aClass);
        }
        return nextHandler().resolve(extra,set);
    }
}
