package cn.easyutil.easyapi.handler.reader.controllers;

import cn.easyutil.easyapi.handler.BaseHandlerChain;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.BaseExtra;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;

import java.util.*;

public class ControllerReaderHandler extends BaseHandlerChain {

    private static final List<HandlerChain<ControllerExtra,String>> authorHandlers = new ArrayList<>();
    private static final List<HandlerChain<ControllerExtra,String>> descriptionHandlers = new ArrayList<>();
    private static final List<HandlerChain<ControllerExtra,Boolean>> ignoreHandlers = new ArrayList<>();
    private static final List<HandlerChain<ControllerExtra,String>> pathHandlers = new ArrayList<>();
    private static final List<HandlerChain<BaseExtra,Set<Class>>> scanHandlers = new ArrayList<>();
    private static final List<HandlerChain<ControllerExtra,Boolean>> showHandlers = new ArrayList<>();
    private static final List<HandlerChain<ControllerExtra,String>> nameHandlers = new ArrayList<>();

    static {
        new DefaultControllerReaderHandler().addDefault();
    }

    public static void addAuthorHandlers(HandlerChain<ControllerExtra,String> handler){
        addChain(authorHandlers,handler);
    }

    public static void addPathHandlers(HandlerChain<ControllerExtra,String> handler){
        addChain(pathHandlers,handler);
    }

    public static void addScanHandlers(HandlerChain<BaseExtra,Set<Class>> handler){
        addChain(scanHandlers,handler);
    }

    public static void addDescriptionHandlers(HandlerChain<ControllerExtra,String> handler) {
        addChain(descriptionHandlers,handler);
    }

    public static void addIgnoreHandlers(HandlerChain<ControllerExtra,Boolean> handler) {
        addChain(ignoreHandlers,handler);
    }

    public static void addNameHandlers(HandlerChain<ControllerExtra,String> handler) {
        addChain(nameHandlers,handler);
    }

    public static void addShowHandlers(HandlerChain<ControllerExtra,Boolean> handler) {
        addChain(showHandlers,handler);
    }

    public static List<HandlerChain<ControllerExtra,String>> getDescriptionHandlers() {
        return descriptionHandlers;
    }

    public static List<HandlerChain<ControllerExtra,Boolean>> getIgnoreHandlers() {
        return ignoreHandlers;
    }

    public static List<HandlerChain<ControllerExtra,String>> getNameHandlers() {
        return nameHandlers;
    }

    public static List<HandlerChain<ControllerExtra,Boolean>> getShowHandlers() {
        return showHandlers;
    }

    public static List<HandlerChain<ControllerExtra,String>> getAuthorHandlers() {
        return authorHandlers;
    }

    public static List<HandlerChain<ControllerExtra,String>> getPathHandlers() {
        return pathHandlers;
    }

    public static List<HandlerChain<BaseExtra,Set<Class>>> getScanHandlers() {
        return scanHandlers;
    }
}
