package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.util.StringUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.stream.Stream;

public class BeanIgnoreCommentReader extends HandlerChain<ModelFieldExtra,Boolean> {

    @Override
    public Boolean resolve(ModelFieldExtra extra, Boolean transfer) {
        Type type = extra.getFieldType();
        if(extra.getField() == null){
            return nextHandler().resolve(extra,false);
        }
        Field field = extra.getField();
        if(type.equals(Serializable.class) || type.equals(HttpServletRequest.class) || type.equals(HttpServletResponse.class)){
            return nextHandler().resolve(extra,true);
        }
        if("serialVersionUID".equals(field.getName())){
            return nextHandler().resolve(extra,true);
        }
        String typeName = type.getTypeName();
        if(typeName.startsWith("sun.")){
            return nextHandler().resolve(extra,true);
        }
        if(type.equals(Class.class)){
            return nextHandler().resolve(extra,true);
        }
        if(extra.getFieldComment()!=null && !StringUtil.isEmpty(extra.getFieldComment().getComment())){
            //如果不在当前分组内，也忽略
            String groups = ApidocCommentUtil.getCommentValue(extra.getFieldComment().getComment(), "groups");
            if(StringUtil.isEmpty(groups) || !groups.startsWith("[") || !groups.endsWith("]")){
                return nextHandler().resolve(extra,false);
            }
            String[] s = groups.substring(1, groups.length() - 1).split(",");
            InterfaceExtra interfaceExtra = extra.getMethodExtra().getInterfaceExtra();
            String path = interfaceExtra.getControllerExtra().getControllerClass().getCanonicalName()+"."+interfaceExtra.getMethod().getName();
            return nextHandler().resolve(extra,Stream.of(s).noneMatch(group -> ApidocCommentUtil.isMatchPath(group,path)));
        }
        return nextHandler().resolve(extra,false);
    }
}
