package cn.easyutil.easyapi.handler.reader.beans;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.BaseHandlerChain;
import cn.easyutil.easyapi.handler.extra.MethodExtra;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.logic.creator.FieldParam;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * 参数bean解析处理器
 */
public class BeanReaderHandler extends BaseHandlerChain {

    //参数校验
    private final static List<HandlerChain<ModelFieldExtra,List<String>>> conditionHandlers = new ArrayList<>();
    //字段说明
    private final static List<HandlerChain<ModelFieldExtra,String>> descriptionHandlers = new ArrayList<>();
    //忽略
    private final static List<HandlerChain<ModelFieldExtra,Boolean>> ignoreHandlers = new ArrayList<>();
    //字段类型
    private final static List<HandlerChain<ModelFieldExtra,JavaType>> javaTypeHandlers = new ArrayList<>();
    //mock模板
    private final static List<HandlerChain<ModelFieldExtra,String>> mockTemplateHandlers = new ArrayList<>();
    //字段名称
    private final static List<HandlerChain<ModelFieldExtra,String>> nameHandlers = new ArrayList<>();
    //字段实际java类型，如果是对象，此处为对象的多个属性
    private final static List<HandlerChain<ModelFieldExtra,List<FieldParam>>> paramHandlers = new ArrayList<>();
    //更新策略
    private final static List<HandlerChain<ModelFieldExtra,RenewType>> renewTypeHandlers = new ArrayList<>();
    //是否必填
    private final static List<HandlerChain<ModelFieldExtra,Boolean>> requiredHandlers = new ArrayList<>();
    //是否显示
    private final static List<HandlerChain<ModelFieldExtra,Boolean>> showHandlers = new ArrayList<>();
    //字段对应的type
    private final static List<HandlerChain<ModelFieldExtra,Type>> typeHandlers = new ArrayList<>();

    static {
        new DefaultBeanReaderHandler().addDefault();
    }

    public static void addConditionHandlers(HandlerChain<ModelFieldExtra,List<String>> handler) {
        addChain(conditionHandlers,handler);
    }

    public static void addDescriptionHandlers(HandlerChain<ModelFieldExtra,String> handler) {
        addChain(descriptionHandlers,handler);
    }

    public static void addIgnoreHandlers(HandlerChain<ModelFieldExtra,Boolean> handler) {
        addChain(ignoreHandlers,handler);
    }

    public static void addJavaTypeHandlers(HandlerChain<ModelFieldExtra,JavaType> handler) {
        addChain(javaTypeHandlers,handler);
    }

    public static void addMockTemplateHandlers(HandlerChain<ModelFieldExtra,String> handler) {
        addChain(mockTemplateHandlers,handler);
    }

    public static void addNameHandlers(HandlerChain<ModelFieldExtra,String> handler) {
        addChain(nameHandlers,handler);
    }

    public static void addParamHandlers(HandlerChain<ModelFieldExtra,List<FieldParam>> handler) {
        addChain(paramHandlers,handler);
    }

    public static void addRenewTypeHandlers(HandlerChain<ModelFieldExtra,RenewType> handler) {
        addChain(renewTypeHandlers,handler);
    }

    public static void addRequiredHandlers(HandlerChain<ModelFieldExtra,Boolean> handler) {
        addChain(requiredHandlers,handler);
    }

    public static void addShowHandlers(HandlerChain<ModelFieldExtra,Boolean> handler) {
        addChain(showHandlers,handler);
    }

    public static void addTypeHandlers(HandlerChain<ModelFieldExtra,Type> handler) {
        addChain(typeHandlers,handler);
    }

    public static List<HandlerChain<ModelFieldExtra,List<String>>> getConditionHandlers() {
        return conditionHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,String>> getDescriptionHandlers() {
        return descriptionHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,Boolean>> getIgnoreHandlers() {
        return ignoreHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,JavaType>> getJavaTypeHandlers() {
        return javaTypeHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,String>> getMockTemplateHandlers() {
        return mockTemplateHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,String>> getNameHandlers() {
        return nameHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,List<FieldParam>>> getParamHandlers() {
        return paramHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,RenewType>> getRenewTypeHandlers() {
        return renewTypeHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,Boolean>> getRequiredHandlers() {
        return requiredHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,Boolean>> getShowHandlers() {
        return showHandlers;
    }

    public static List<HandlerChain<ModelFieldExtra,Type>> getTypeHandlers() {
        return typeHandlers;
    }
}
