package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

/**
 * 返回数据外包装
 * @author spc
 *
 */
@TableName("EASYAPI_MODULE_OUT_PACKAGE")
public class DBModuleOutPackageEntity extends BaseDbEntity {

	@DDL(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
	@ApidocComment("所属模块id")
	private Long moduleId;

	@DDL(value = "KEY",ddl = "`KEY` varchar(100) DEFAULT NULL COMMENT '包装的key'")
	@ApidocComment("包装的key")
	@TableField("`key`")
	private String key;

	@DDL(value = "TYPE",ddl = "`TYPE` int(2) DEFAULT 0 COMMENT '类型  0-请求参数包装  1-响应参数包装'")
	@ApidocComment("类型  0-请求参数包装  1-响应参数包装")
	private Integer type;

	@DDL(value = "VAL",ddl = "`VAL` varchar(255) DEFAULT NULL COMMENT '包装的val,如果是默认，则会替换真实数据'")
	@ApidocComment("包装的val,如果是默认，则会替换真实数据")
	private String val;

	@DDL(value = "DEFAULT_STATUS",ddl = "`DEFAULT_STATUS` int(1) DEFAULT 0 COMMENT '默认状态：0-缺省默认值  1-数据包装'")
	@ApidocComment("默认状态：0-缺省默认值  1-数据包装")
	private Integer defaultStatus;

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getVal() {
		return val;
	}

	public void setVal(String val) {
		this.val = val;
	}

	public Integer getDefaultStatus() {
		return defaultStatus;
	}

	public void setDefaultStatus(Integer defaultStatus) {
		this.defaultStatus = defaultStatus;
	}
}
