package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;

/**
 * db存储基类
 */
public class BaseDbEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    @DDL(value = "ID",ddl="`ID` bigint(20) NOT NULL AUTO_INCREMENT")
    @TableId(type = IdType.AUTO)
    protected Long id;

    @DDL(value = "CREATE_TIME",ddl = "`CREATE_TIME` bigint(20) DEFAULT NULL")
    protected Long createTime;

    @DDL(value = "UPDATE_TIME",ddl = "`UPDATE_TIME` bigint(20) DEFAULT NULL")
    protected Long updateTime;

    @DDL(value = "DELETED",ddl = "`DELETED` int(1) DEFAULT 0")
    protected Integer deleted;

    /**
     * 项目id
     */
    @DDL(value = "PROJECT_ID",ddl = "`PROJECT_ID` bigint(20) DEFAULT NULL COMMENT '项目id'")
    protected Long projectId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
}
