package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ResponseExtra;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.response")
public class EasyApiResponseReaderFilter {

    //字段说明
    private Set<Class<List<HandlerChain<ResponseExtra,String>>>> description = new HashSet<>();

    //忽略
    private Set<Class<List<HandlerChain<ResponseExtra,Boolean>>>> ignore = new HashSet<>();

    //mock模板
    private Set<Class<List<HandlerChain<ResponseExtra,String>>>> mockTemplate = new HashSet<>();

    //是否必填
    private Set<Class<List<HandlerChain<ResponseExtra,Boolean>>>> required = new HashSet<>();

    //是否显示
    private Set<Class<List<HandlerChain<ResponseExtra,Boolean>>>> show = new HashSet<>();

    //字段对应的type
    private Set<Class<List<HandlerChain<ResponseExtra,List<MethodParam>>>>> returnType = new HashSet<>();

    public Set<Class<List<HandlerChain<ResponseExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(Set<Class<List<HandlerChain<ResponseExtra, String>>>> description) {
        this.description = description;
    }

    public Set<Class<List<HandlerChain<ResponseExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<List<HandlerChain<ResponseExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<List<HandlerChain<ResponseExtra, String>>>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(Set<Class<List<HandlerChain<ResponseExtra, String>>>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public Set<Class<List<HandlerChain<ResponseExtra, Boolean>>>> getRequired() {
        return required;
    }

    public void setRequired(Set<Class<List<HandlerChain<ResponseExtra, Boolean>>>> required) {
        this.required = required;
    }

    public Set<Class<List<HandlerChain<ResponseExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(Set<Class<List<HandlerChain<ResponseExtra, Boolean>>>> show) {
        this.show = show;
    }

    public Set<Class<List<HandlerChain<ResponseExtra, List<MethodParam>>>>> getReturnType() {
        return returnType;
    }

    public void setReturnType(Set<Class<List<HandlerChain<ResponseExtra, List<MethodParam>>>>> returnType) {
        this.returnType = returnType;
    }
}
