package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.MockExtra;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.request")
public class EasyApiRequestReaderFilter {

    //参数校验
    private Set<Class<List<HandlerChain<RequestExtra,List<String>>>>> condition = new HashSet<>();

    //字段说明
    private Set<Class<List<HandlerChain<RequestExtra,String>>>> description = new HashSet<>();

    //忽略
    private Set<Class<List<HandlerChain<RequestExtra,Boolean>>>> ignore = new HashSet<>();

    //mock模板
    private Set<Class<List<HandlerChain<RequestExtra,String>>>> mockTemplate = new HashSet<>();

    //字段名称
    private Set<Class<List<HandlerChain<RequestExtra,String>>>> name = new HashSet<>();

    //字段实际java类型，如果是对象，此处为对象的多个属性
    private Set<Class<List<HandlerChain<RequestExtra,List<MethodParam>>>>> param = new HashSet<>();

    //是否必填
    private Set<Class<List<HandlerChain<RequestExtra,Boolean>>>> required = new HashSet<>();

    //是否显示
    private Set<Class<List<HandlerChain<RequestExtra,Boolean>>>> show = new HashSet<>();

    //字段类型
    private Set<Class<List<HandlerChain<RequestExtra, Type>>>> type = new HashSet<>();


    public Set<Class<List<HandlerChain<RequestExtra, List<String>>>>> getCondition() {
        return condition;
    }

    public void setCondition(Set<Class<List<HandlerChain<RequestExtra, List<String>>>>> condition) {
        this.condition = condition;
    }

    public Set<Class<List<HandlerChain<RequestExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(Set<Class<List<HandlerChain<RequestExtra, String>>>> description) {
        this.description = description;
    }

    public Set<Class<List<HandlerChain<RequestExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<List<HandlerChain<RequestExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<List<HandlerChain<RequestExtra, String>>>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(Set<Class<List<HandlerChain<RequestExtra, String>>>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public Set<Class<List<HandlerChain<RequestExtra, String>>>> getName() {
        return name;
    }

    public void setName(Set<Class<List<HandlerChain<RequestExtra, String>>>> name) {
        this.name = name;
    }

    public Set<Class<List<HandlerChain<RequestExtra, List<MethodParam>>>>> getParam() {
        return param;
    }

    public void setParam(Set<Class<List<HandlerChain<RequestExtra, List<MethodParam>>>>> param) {
        this.param = param;
    }

    public Set<Class<List<HandlerChain<RequestExtra, Boolean>>>> getRequired() {
        return required;
    }

    public void setRequired(Set<Class<List<HandlerChain<RequestExtra, Boolean>>>> required) {
        this.required = required;
    }

    public Set<Class<List<HandlerChain<RequestExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(Set<Class<List<HandlerChain<RequestExtra, Boolean>>>> show) {
        this.show = show;
    }

    public Set<Class<List<HandlerChain<RequestExtra, Type>>>> getType() {
        return type;
    }

    public void setType(Set<Class<List<HandlerChain<RequestExtra, Type>>>> type) {
        this.type = type;
    }
}
