package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.interface")
public class EasyApiInterfaceReaderFilter {

    //请求体类型
    private Set<Class<List<HandlerChain<InterfaceExtra, BodyType>>>> bodyType = new HashSet<>();

    //搜索关键字
    private Set<Class<List<HandlerChain<InterfaceExtra, List<String>>>>> search = new HashSet<>();

    //接口描述
    private Set<Class<List<HandlerChain<InterfaceExtra, String>>>> description = new HashSet<>();

    //开启请求包装
    private Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableReqPackage = new HashSet<>();

    //开启响应包装
    private Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableResPackage = new HashSet<>();

    //忽略
    private Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> ignore = new HashSet<>();

    //更新策略
    private Set<Class<List<HandlerChain<InterfaceExtra, RenewType>>>> renewType = new HashSet<>();

    //请求方法
    private Set<Class<List<HandlerChain<InterfaceExtra, RequestMethod>>>> requestMethod = new HashSet<>();

    //请求参数说明
    private Set<Class<List<HandlerChain<InterfaceExtra, String>>>> requestNote = new HashSet<>();

    //请求路径
    private Set<Class<List<HandlerChain<InterfaceExtra, String>>>> url = new HashSet<>();

    //响应参数说明
    private Set<Class<List<HandlerChain<InterfaceExtra, String>>>> responseNote = new HashSet<>();

    //扫描接口
    private Set<Class<List<HandlerChain<InterfaceExtra, List<Method>>>>> scan = new HashSet<>();

    //是否显示
    private Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> show = new HashSet<>();

    //接口名字
    private Set<Class<List<HandlerChain<InterfaceExtra, String>>>> name = new HashSet<>();

    //接口唯一标识
    private Set<Class<List<HandlerChain<InterfaceExtra, String>>>> unique = new HashSet<>();

    //模拟请求时的校验
    private Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> verifyMockTag = new HashSet<>();

    public Set<Class<List<HandlerChain<InterfaceExtra, BodyType>>>> getBodyType() {
        return bodyType;
    }

    public void setBodyType(Set<Class<List<HandlerChain<InterfaceExtra, BodyType>>>> bodyType) {
        this.bodyType = bodyType;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, List<String>>>>> getSearch() {
        return search;
    }

    public void setSearch(Set<Class<List<HandlerChain<InterfaceExtra, List<String>>>>> search) {
        this.search = search;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(Set<Class<List<HandlerChain<InterfaceExtra, String>>>> description) {
        this.description = description;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getEnableReqPackage() {
        return enableReqPackage;
    }

    public void setEnableReqPackage(Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableReqPackage) {
        this.enableReqPackage = enableReqPackage;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getEnableResPackage() {
        return enableResPackage;
    }

    public void setEnableResPackage(Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> enableResPackage) {
        this.enableResPackage = enableResPackage;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, RenewType>>>> getRenewType() {
        return renewType;
    }

    public void setRenewType(Set<Class<List<HandlerChain<InterfaceExtra, RenewType>>>> renewType) {
        this.renewType = renewType;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, RequestMethod>>>> getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(Set<Class<List<HandlerChain<InterfaceExtra, RequestMethod>>>> requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, String>>>> getRequestNote() {
        return requestNote;
    }

    public void setRequestNote(Set<Class<List<HandlerChain<InterfaceExtra, String>>>> requestNote) {
        this.requestNote = requestNote;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, String>>>> getUrl() {
        return url;
    }

    public void setUrl(Set<Class<List<HandlerChain<InterfaceExtra, String>>>> url) {
        this.url = url;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, String>>>> getResponseNote() {
        return responseNote;
    }

    public void setResponseNote(Set<Class<List<HandlerChain<InterfaceExtra, String>>>> responseNote) {
        this.responseNote = responseNote;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, List<Method>>>>> getScan() {
        return scan;
    }

    public void setScan(Set<Class<List<HandlerChain<InterfaceExtra, List<Method>>>>> scan) {
        this.scan = scan;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> show) {
        this.show = show;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, String>>>> getName() {
        return name;
    }

    public void setName(Set<Class<List<HandlerChain<InterfaceExtra, String>>>> name) {
        this.name = name;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, String>>>> getUnique() {
        return unique;
    }

    public void setUnique(Set<Class<List<HandlerChain<InterfaceExtra, String>>>> unique) {
        this.unique = unique;
    }

    public Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> getVerifyMockTag() {
        return verifyMockTag;
    }

    public void setVerifyMockTag(Set<Class<List<HandlerChain<InterfaceExtra, Boolean>>>> verifyMockTag) {
        this.verifyMockTag = verifyMockTag;
    }
}
