package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 控制器解析
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.controller")
public class EasyApiControllerReaderFilter {

    //作者
    private Set<Class<List<HandlerChain<ControllerExtra,String>>>> author = new HashSet<>();

    //控制器说明
    private Set<Class<List<HandlerChain<ControllerExtra,String>>>> description = new HashSet<>();

    //忽略
    private Set<Class<List<HandlerChain<ControllerExtra,Boolean>>>> ignore = new HashSet<>();

    //父路径提取
    private Set<Class<List<HandlerChain<ControllerExtra,String>>>> path = new HashSet<>();

    //扫描控制器
    private Set<Class<List<HandlerChain<ControllerExtra,Set<Class>>>>> scan = new HashSet<>();

    //是否显示
    private Set<Class<List<HandlerChain<ControllerExtra,Boolean>>>> show = new HashSet<>();

    //控制器名称
    private Set<Class<List<HandlerChain<ControllerExtra,String>>>> name = new HashSet<>();


    public Set<Class<List<HandlerChain<ControllerExtra, String>>>> getAuthor() {
        return author;
    }

    public void setAuthor(Set<Class<List<HandlerChain<ControllerExtra, String>>>> author) {
        this.author = author;
    }

    public Set<Class<List<HandlerChain<ControllerExtra, String>>>> getDescription() {
        return description;
    }

    public void setDescription(Set<Class<List<HandlerChain<ControllerExtra, String>>>> description) {
        this.description = description;
    }

    public Set<Class<List<HandlerChain<ControllerExtra, Boolean>>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<List<HandlerChain<ControllerExtra, Boolean>>>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<List<HandlerChain<ControllerExtra, String>>>> getPath() {
        return path;
    }

    public void setPath(Set<Class<List<HandlerChain<ControllerExtra, String>>>> path) {
        this.path = path;
    }

    public Set<Class<List<HandlerChain<ControllerExtra, Set<Class>>>>> getScan() {
        return scan;
    }

    public void setScan(Set<Class<List<HandlerChain<ControllerExtra, Set<Class>>>>> scan) {
        this.scan = scan;
    }

    public Set<Class<List<HandlerChain<ControllerExtra, Boolean>>>> getShow() {
        return show;
    }

    public void setShow(Set<Class<List<HandlerChain<ControllerExtra, Boolean>>>> show) {
        this.show = show;
    }

    public Set<Class<List<HandlerChain<ControllerExtra, String>>>> getName() {
        return name;
    }

    public void setName(Set<Class<List<HandlerChain<ControllerExtra, String>>>> name) {
        this.name = name;
    }
}
