package cn.easyutil.easyapi.configuration.filter;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 参数bean解析过滤
 */
@Component
@ConfigurationProperties(prefix = "easyapi.filter.bean")
public class EasyApiBeanReaderFilter {

    //参数校验
    private Set<Class<HandlerChain<ModelFieldExtra, List<String>>>> condition = new HashSet<>();

    //字段说明
    private Set<Class<HandlerChain<ModelFieldExtra, String>>> description = new HashSet<>();

    //忽略
    private Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> ignore = new HashSet<>();

    //字段类型
    private Set<Class<HandlerChain<ModelFieldExtra, JavaType>>> javaType = new HashSet<>();

    //mock模板
    private Set<Class<HandlerChain<ModelFieldExtra, String>>> mockTemplate = new HashSet<>();

    //字段名称
    private Set<Class<HandlerChain<ModelFieldExtra, String>>> name = new HashSet<>();

    //字段实际java类型，如果是对象，此处为对象的多个属性
    private Set<Class<HandlerChain<ModelFieldExtra, List<FieldParam>>>> param = new HashSet<>();

    //更新策略
    private Set<Class<HandlerChain<ModelFieldExtra, RenewType>>> renewType = new HashSet<>();

    //是否必填
    private Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> required = new HashSet<>();

    //是否显示
    private Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> show = new HashSet<>();

    //字段对应的type
    private Set<Class<HandlerChain<ModelFieldExtra, Type>>> type = new HashSet<>();


    public Set<Class<HandlerChain<ModelFieldExtra, List<String>>>> getCondition() {
        return condition;
    }

    public void setCondition(Set<Class<HandlerChain<ModelFieldExtra, List<String>>>> condition) {
        this.condition = condition;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, String>>> getDescription() {
        return description;
    }

    public void setDescription(Set<Class<HandlerChain<ModelFieldExtra, String>>> description) {
        this.description = description;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> getIgnore() {
        return ignore;
    }

    public void setIgnore(Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> ignore) {
        this.ignore = ignore;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, JavaType>>> getJavaType() {
        return javaType;
    }

    public void setJavaType(Set<Class<HandlerChain<ModelFieldExtra, JavaType>>> javaType) {
        this.javaType = javaType;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, String>>> getMockTemplate() {
        return mockTemplate;
    }

    public void setMockTemplate(Set<Class<HandlerChain<ModelFieldExtra, String>>> mockTemplate) {
        this.mockTemplate = mockTemplate;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, String>>> getName() {
        return name;
    }

    public void setName(Set<Class<HandlerChain<ModelFieldExtra, String>>> name) {
        this.name = name;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, List<FieldParam>>>> getParam() {
        return param;
    }

    public void setParam(Set<Class<HandlerChain<ModelFieldExtra, List<FieldParam>>>> param) {
        this.param = param;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, RenewType>>> getRenewType() {
        return renewType;
    }

    public void setRenewType(Set<Class<HandlerChain<ModelFieldExtra, RenewType>>> renewType) {
        this.renewType = renewType;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> getRequired() {
        return required;
    }

    public void setRequired(Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> required) {
        this.required = required;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> getShow() {
        return show;
    }

    public void setShow(Set<Class<HandlerChain<ModelFieldExtra, Boolean>>> show) {
        this.show = show;
    }

    public Set<Class<HandlerChain<ModelFieldExtra, Type>>> getType() {
        return type;
    }

    public void setType(Set<Class<HandlerChain<ModelFieldExtra, Type>>> type) {
        this.type = type;
    }
}
