package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.EasyapiRun;
import cn.easyutil.easyapi.configuration.filter.*;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.handler.BaseHandlerChain;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ApiExtra;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.handler.reader.beans.BeanReaderHandler;
import cn.easyutil.easyapi.handler.reader.controllers.ControllerReaderHandler;
import cn.easyutil.easyapi.handler.reader.interfaces.InterfaceReaderHandler;
import cn.easyutil.easyapi.handler.reader.mocks.MockReaderHandler;
import cn.easyutil.easyapi.handler.reader.requests.RequestReaderHandler;
import cn.easyutil.easyapi.handler.reader.responses.ResponseReaderHandler;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

@Configuration
@Import({EasyApiBaseConfiguration.class
        , EasyApiDataConfiguration.class
        , EasyApiUserConfiguration.class
        , EasyApiGlobalResponseConfiguration.class
        , EasyApiGlobalRequestConfiguration.class
        , EasyApiBeanReaderFilter.class
        , EasyApiControllerReaderFilter.class
        , EasyApiInterfaceReaderFilter.class
        , EasyApiMockReaderFilter.class
        , EasyApiRequestReaderFilter.class
        ,EasyApiResponseReaderFilter.class
        ,SpringRunEnvClassComponent.class})
@ConditionalOnMissingBean(AbstractConfigurationCreator.class)
@ConditionalOnProperty(prefix = "easyapi",name = "enable",havingValue = "true")
public class EasyApiAutoConfiguration implements InitializingBean {

    @Resource
    private EasyApiBaseConfiguration configuration;
    @Resource
    private EasyApiDataConfiguration dataConfiguration;
    @Resource
    private EasyApiUserConfiguration userConfiguration;
    @Resource
    private EasyApiGlobalRequestConfiguration requestConfiguration;
    @Resource
    private EasyApiGlobalResponseConfiguration responseConfiguration;
    @Resource
    private EasyApiBeanReaderFilter beanFilter;
    @Resource
    private EasyApiControllerReaderFilter controllerFilter;
    @Resource
    private EasyApiInterfaceReaderFilter interfaceFilter;
    @Resource
    private EasyApiMockReaderFilter mockFilter;
    @Resource
    private EasyApiRequestReaderFilter requestFilter;
    @Resource
    private EasyApiResponseReaderFilter responseFilter;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void afterPropertiesSet(){
        AllConfiguration all = new AllConfiguration();
        all.setConfiguration(configuration);
        all.setDataConfiguration(dataConfiguration);
        all.setUserConfiguration(userConfiguration);
        all.setGlobalRequestConfiguration(requestConfiguration);
        all.setGlobalResponseConfiguration(responseConfiguration);
        all.setBeanFilter(beanFilter);
        all.setControllerFilter(controllerFilter);
        all.setInterfaceFilter(interfaceFilter);
        all.setMockFilter(mockFilter);
        all.setRequestFilter(requestFilter);
        all.setResponseFilter(responseFilter);
        processBeanFilter();
        processControllerFilter();
        processInterfaceFilter();
        processMockFilter();
        processRequestFilter();
        processResponseFilter();
        //生成接口文档
        EasyapiRun run = new EasyapiRun(all,applicationContext);
        run.run();
    }

    private void processBeanFilter(){
        if(this.beanFilter == null){
            return ;
        }
        beanFilter.getCondition().forEach(chain -> addChain(BeanReaderHandler.getConditionHandlers(),chain));
        beanFilter.getDescription().forEach(chain -> addChain(BeanReaderHandler.getDescriptionHandlers(),chain));
        beanFilter.getIgnore().forEach(chain -> addChain(BeanReaderHandler.getIgnoreHandlers(),chain));
        beanFilter.getJavaType().forEach(chain -> addChain(BeanReaderHandler.getJavaTypeHandlers(),chain));
        beanFilter.getMockTemplate().forEach(chain -> addChain(BeanReaderHandler.getMockTemplateHandlers(),chain));
        beanFilter.getName().forEach(chain -> addChain(BeanReaderHandler.getNameHandlers(),chain));
        beanFilter.getParam().forEach(chain -> addChain(BeanReaderHandler.getParamHandlers(),chain));
        beanFilter.getRenewType().forEach(chain -> addChain(BeanReaderHandler.getRenewTypeHandlers(),chain));
        beanFilter.getRequired().forEach(chain -> addChain(BeanReaderHandler.getRequiredHandlers(),chain));
        beanFilter.getShow().forEach(chain -> addChain(BeanReaderHandler.getShowHandlers(),chain));
        beanFilter.getType().forEach(chain -> addChain(BeanReaderHandler.getTypeHandlers(),chain));
    }

    private void processControllerFilter(){
        if(this.controllerFilter == null){
            return ;
        }
        controllerFilter.getAuthor().forEach(chain -> addChain(ControllerReaderHandler.getAuthorHandlers(),chain));
        controllerFilter.getDescription().forEach(chain -> addChain(ControllerReaderHandler.getDescriptionHandlers(),chain));
        controllerFilter.getIgnore().forEach(chain -> addChain(ControllerReaderHandler.getIgnoreHandlers(),chain));
        controllerFilter.getPath().forEach(chain -> addChain(ControllerReaderHandler.getPathHandlers(),chain));
        controllerFilter.getScan().forEach(chain -> addChain(ControllerReaderHandler.getScanHandlers(),chain));
        controllerFilter.getShow().forEach(chain -> addChain(ControllerReaderHandler.getShowHandlers(),chain));
        controllerFilter.getName().forEach(chain -> addChain(ControllerReaderHandler.getNameHandlers(),chain));
    }

    private void processInterfaceFilter(){
        if(this.interfaceFilter == null){
            return ;
        }
        interfaceFilter.getBodyType().forEach(chain -> addChain(InterfaceReaderHandler.getBodyTypeHandlers(),chain));
        interfaceFilter.getSearch().forEach(chain -> addChain(InterfaceReaderHandler.getSearchHandlers(),chain));
        interfaceFilter.getDescription().forEach(chain -> addChain(InterfaceReaderHandler.getDescriptionHandlers(),chain));
        interfaceFilter.getEnableReqPackage().forEach(chain -> addChain(InterfaceReaderHandler.getEnableReqPackageHandlers(),chain));
        interfaceFilter.getEnableResPackage().forEach(chain -> addChain(InterfaceReaderHandler.getEnableResPackageHandlers(),chain));
        interfaceFilter.getIgnore().forEach(chain -> addChain(InterfaceReaderHandler.getIgnoreHandlers(),chain));
        interfaceFilter.getRenewType().forEach(chain -> addChain(InterfaceReaderHandler.getRenewTypeHandlers(),chain));
        interfaceFilter.getRequestMethod().forEach(chain -> addChain(InterfaceReaderHandler.getRequestMethodHandlers(),chain));
        interfaceFilter.getRequestNote().forEach(chain -> addChain(InterfaceReaderHandler.getRequestNoteHandlers(),chain));
        interfaceFilter.getUrl().forEach(chain -> addChain(InterfaceReaderHandler.getUrlHandlers(),chain));
        interfaceFilter.getResponseNote().forEach(chain -> addChain(InterfaceReaderHandler.getResponseNoteHandlers(),chain));
        interfaceFilter.getScan().forEach(chain -> addChain(InterfaceReaderHandler.getScanHandlers(),chain));
        interfaceFilter.getShow().forEach(chain -> addChain(InterfaceReaderHandler.getShowHandlers(),chain));
        interfaceFilter.getName().forEach(chain -> addChain(InterfaceReaderHandler.getNameHandlers(),chain));
        interfaceFilter.getUnique().forEach(chain -> addChain(InterfaceReaderHandler.getUniqueHandlers(),chain));
        interfaceFilter.getVerifyMockTag().forEach(chain -> addChain(InterfaceReaderHandler.getVerifyMockTagHandlers(),chain));
    }

    private void processMockFilter(){
        if(this.mockFilter == null){
            return ;
        }
        mockFilter.getMock().forEach(chain -> addChain(MockReaderHandler.getMockHandlers(),chain));
    }

    private void processRequestFilter(){
        if(this.requestFilter == null){
            return ;
        }
        requestFilter.getCondition().forEach(chain -> addChain(RequestReaderHandler.getConditionHandlers(),chain));
        requestFilter.getDescription().forEach(chain -> addChain(RequestReaderHandler.getDescriptionHandlers(),chain));
        requestFilter.getIgnore().forEach(chain -> addChain(RequestReaderHandler.getIgnoreHandlers(),chain));
        requestFilter.getMockTemplate().forEach(chain -> addChain(RequestReaderHandler.getMockTemplateHandlers(),chain));
        requestFilter.getName().forEach(chain -> addChain(RequestReaderHandler.getNameHandlers(),chain));
        requestFilter.getParam().forEach(chain -> addChain(RequestReaderHandler.getParamHandlers(),chain));
        requestFilter.getRequired().forEach(chain -> addChain(RequestReaderHandler.getRequiredHandlers(),chain));
        requestFilter.getShow().forEach(chain -> addChain(RequestReaderHandler.getShowHandlers(),chain));
        requestFilter.getType().forEach(chain -> addChain(RequestReaderHandler.getTypeHandlers(),chain));
    }

    private void processResponseFilter(){
        if(this.responseFilter == null){
            return ;
        }
        responseFilter.getDescription().forEach(chain -> addChain(ResponseReaderHandler.getDescriptionHandlers(),chain));
        responseFilter.getIgnore().forEach(chain -> addChain(ResponseReaderHandler.getIgnoreHandlers(),chain));
        responseFilter.getMockTemplate().forEach(chain -> addChain(ResponseReaderHandler.getMockTemplateHandlers(),chain));
        responseFilter.getRequired().forEach(chain -> addChain(ResponseReaderHandler.getRequiredHandlers(),chain));
        responseFilter.getShow().forEach(chain -> addChain(ResponseReaderHandler.getShowHandlers(),chain));
        responseFilter.getReturnType().forEach(chain -> addChain(ResponseReaderHandler.getTypeHandlers(),chain));
    }

    private <E extends ApiExtra,T> void addChain(List<HandlerChain<E,T>> list, Class clazz){
        try {
            HandlerChain chain = (HandlerChain) clazz.newInstance();
            BaseHandlerChain.addChain(list,chain);
        }catch (Exception e) {
            throw new ApidocException(e);
        }
    }
}
