/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.extra.MethodExtra;
import cn.easyutil.easyapi.handler.extra.MockExtra;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.handler.operator.BeanReader;
import cn.easyutil.easyapi.handler.operator.MockReader;
import cn.easyutil.easyapi.handler.operator.provide.MockReaderProvider;
import cn.easyutil.easyapi.javadoc.reader.CommentDetail;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class JavaBeanCreator {
    private BeanReader filter;
    private MockReader mockFilter;
    private Set<String> projectBasePaths;
    private MethodExtra methodExtra;

    public JavaBeanCreator(MethodExtra methodExtra) {
        this.methodExtra = methodExtra;
        this.filter = ProjectContext.beanOperator;
        this.mockFilter = new MockReaderProvider();
        this.setMethodExtra(methodExtra);
        this.projectBasePaths = ProjectContext.projectBasePath;
    }

    public static JavaBeanCreator builder(MethodExtra methodExtra) {
        return new JavaBeanCreator(methodExtra);
    }

    private String buildCreatersKey(Class aClass, GenericTypeBind bind) {
        String bindKey = "";
        if (bind.keys().size() > 0) {
            for (String key : bind.keys()) {
                bindKey = bindKey + bind.get(key);
            }
        }
        return aClass.getCanonicalName() + bindKey;
    }

    public List<DocParamEntity> readBean(Type type, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Class aClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
        binds.binds(currentBinds);
        if (aClass == Object.class || aClass == Class.class) {
            return Collections.emptyList();
        }
        String creatersKey = this.buildCreatersKey(aClass, currentBinds);
        if (exists.containsKey(creatersKey)) {
            return JsonUtil.jsonToList(JsonUtil.beanToJson(exists.get(creatersKey)), DocParamEntity.class);
        }
        exists.put(creatersKey, Collections.emptyList());
        ArrayList<DocParamEntity> bean = new ArrayList();
        JavaType javaType = JavaType.getJavaTypeByType(type);
        switch (javaType) {
            case Object: {
                bean = this.getBean(aClass, binds, exists);
                break;
            }
            case ArrayObject: {
                bean = this.readArrayObject(type, binds, exists);
                break;
            }
            case Array: {
                bean = this.readArray(type, binds);
            }
        }
        exists.put(creatersKey, bean);
        return bean;
    }

    public List<DocParamEntity> readArray(Type type, GenericTypeBind binds) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type)) {
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            arrayType = bindType != null ? bindType : genericTypeBind.get(0);
        }
        DocParamEntity childrean = new DocParamEntity();
        childrean.setRequired(0);
        childrean.setShow(0);
        ModelFieldExtra fieldExtra = new ModelFieldExtra(this.methodExtra);
        fieldExtra.setFieldType(type);
        fieldExtra.setFieldTypeBind(binds);
        RenewType renewType = this.filter.renewType(fieldExtra, null);
        childrean.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
        childrean.setJavaType(JavaType.getJavaTypeByType(arrayType).getType());
        childrean.setClassName(type.getTypeName());
        childrean.setName("_null");
        MockExtra mockExtra = new MockExtra();
        mockExtra.setTemplate(childrean.getMockTemplate());
        mockExtra.setJavaType(JavaType.getType(childrean.getJavaType()));
        Object mockValue = this.mockFilter.mock(mockExtra, null);
        childrean.setMockValue(ObjectUtil.isBaseObject(mockValue) ? mockValue.toString() : JsonUtil.beanToJson(mockValue));
        childrean.setOrigin(EasyapiOriginUtil.createOrigin(childrean));
        return Collections.singletonList(childrean);
    }

    public List<DocParamEntity> readArrayObject(Type type, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Class<Map> arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type) && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass((Type)((Object)arrayType)))) {
            arrayType = binds.get(0);
        }
        if (arrayType instanceof Class && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass((Type)((Object)arrayType)))) {
            arrayType = Map.class;
        }
        return this.readBean((Type)((Object)arrayType), binds, exists);
    }

    private List<DocParamEntity> getBean(Class<?> beanClass, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        ArrayList<DocParamEntity> result = new ArrayList<DocParamEntity>();
        Class<?> clazz = beanClass;
        HashSet<String> fieldNames = new HashSet<String>();
        while (clazz != null && !clazz.equals(Object.class) && clazz != Class.class) {
            String projectBasePath;
            File beanFile = null;
            Iterator<String> iterator = this.projectBasePaths.iterator();
            while (iterator.hasNext() && !(beanFile = CreatorCommonMethod.getClassFile(clazz, projectBasePath = iterator.next())).exists()) {
            }
            JavaSourceReader classFileReader = new JavaSourceReader();
            if (beanFile != null && beanFile.exists()) {
                classFileReader = JavaSourceReader.builder(beanFile);
            }
            List<FieldComment> fieldComments = classFileReader.getComment().getFields();
            Map<String, FieldComment> fieldComment = fieldComments.stream().collect(Collectors.toMap(JavaSourceComment::getName, item -> item));
            ModelFieldExtra fieldExtra = new ModelFieldExtra(this.methodExtra);
            fieldExtra.setModelType(clazz);
            fieldExtra.setModelTypeBind(binds);
            List<FieldParam> params = this.filter.params(fieldExtra, null);
            if (params == null) {
                clazz = clazz.getSuperclass();
                continue;
            }
            for (FieldParam param : params) {
                List<CommentDetail> commentDetails;
                CommentDetail detail;
                JavaType javaType;
                Object bindType;
                Class<Map> ownerClass;
                Field field = param.getField();
                Class<Map> type = param.getParamType();
                String paramName = param.getParamName();
                GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes((Type)((Object)type));
                fieldExtra.setFieldName(paramName);
                fieldExtra.setField(field);
                fieldExtra.setFieldType((Type)((Object)type));
                fieldExtra.setFieldTypeBind(currentBinds);
                if (field != null) {
                    fieldExtra.setFieldComment(Optional.ofNullable(fieldComment.get(field.getName())).orElse(new FieldComment()));
                }
                if (StringUtil.isEmpty(paramName = this.filter.name(fieldExtra, null))) continue;
                Type newType = this.filter.type(fieldExtra, null);
                if (!newType.equals(type)) {
                    currentBinds = GenericTypeUtil.getGenericTypes((Type)((Object)type));
                    fieldExtra.setFieldTypeBind(currentBinds);
                    fieldExtra.setFieldType(newType);
                    type = newType;
                }
                if (this.filter.ignore(fieldExtra, null).booleanValue()) continue;
                int size = fieldNames.size();
                fieldNames.add(paramName);
                if (size == fieldNames.size() || (ownerClass = GenericTypeUtil.getOwnerClass((Type)((Object)type))) == null) continue;
                if (GenericTypeUtil.isGeneric((Type)((Object)type)) && !GenericTypeUtil.isArray((Type)((Object)type)) && (bindType = binds.matchVariable(type.getTypeName())) != null) {
                    type = bindType;
                    ownerClass = GenericTypeUtil.getOwnerClass((Type)((Object)type));
                }
                currentBinds = GenericTypeUtil.getGenericTypes((Type)((Object)type));
                if (ownerClass == null) continue;
                bindType = currentBinds.keys().iterator();
                while (bindType.hasNext()) {
                    String key2 = (String)bindType.next();
                    Type matchType = binds.matchVariable(currentBinds.get(key2).getTypeName());
                    if (matchType == null) continue;
                    currentBinds.bind(key2, matchType);
                }
                if (currentBinds.size() == 0) {
                    currentBinds.binds(binds);
                }
                fieldExtra.setFieldTypeBind(currentBinds);
                String description = this.filter.description(fieldExtra, null);
                if (StringUtil.isEmpty(description)) {
                    description = paramName;
                }
                if (!GenericTypeUtil.isArray((Type)((Object)type)) && ownerClass == Class.class) {
                    ownerClass = Map.class;
                    type = Map.class;
                }
                if ((javaType = this.filter.javaType(fieldExtra, null)) == null) continue;
                DocParamEntity entity = new DocParamEntity();
                entity.setName(paramName);
                entity.setClassName(ownerClass.getCanonicalName());
                entity.setDescription(description);
                entity.setJavaType(javaType.getType());
                entity.setMockTemplate(this.filter.mockTemplate(fieldExtra, null));
                entity.setShow(this.filter.show(fieldExtra, null) != false ? 1 : 0);
                entity.setRequired(this.filter.required(fieldExtra, null) != false ? 1 : 0);
                entity.setConditionTemplate(String.join((CharSequence)",", this.filter.conditions(fieldExtra, null)));
                FieldComment fComment = fieldComment.get(paramName);
                boolean isEnumDescription = false;
                if (fComment != null && !CollectionUtils.isEmpty(fComment.getCommentDetails()) && (detail = (CommentDetail)(commentDetails = fComment.getCommentDetails()).stream().filter(item -> "see".equals(item.getKey())).findFirst().orElse(null)) != null) {
                    try {
                        Class<?> aClass = Class.forName(detail.getValue().trim());
                        Map<String, List<String>> enumFields = ObjectUtil.getEnumFields(aClass);
                        if (!CollectionUtils.isEmpty(enumFields)) {
                            isEnumDescription = true;
                            StringBuilder sb = new StringBuilder();
                            enumFields.forEach((key, value) -> sb.append((String)key).append("<").append(String.join((CharSequence)":", value)).append(">").append(","));
                            entity.setDescription(entity.getDescription() + "=>" + sb.substring(0, sb.length() - 1));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                switch (javaType) {
                    case Object: {
                        if (ownerClass.isEnum()) {
                            if (isEnumDescription) break;
                            Map<String, List<String>> enumFields = ObjectUtil.getEnumFields(ownerClass);
                            entity.setJavaType(JavaType.String.getType());
                            entity.setDescription(entity.getDescription() + "=>" + String.join((CharSequence)",", enumFields.keySet()));
                            entity.setMockTemplate(enumFields.keySet().iterator().next());
                            entity.setMockValue(enumFields.keySet().iterator().next());
                            break;
                        }
                    }
                    case ArrayObject: 
                    case Array: {
                        entity.setChildren(this.readBean((Type)((Object)type), currentBinds, exists));
                        break;
                    }
                    default: {
                        MockExtra mockExtra = new MockExtra();
                        mockExtra.setJavaType(javaType);
                        mockExtra.setTemplate(entity.getMockTemplate());
                        Object mockValue = this.mockFilter.mock(mockExtra, null);
                        entity.setMockValue(ObjectUtil.isBaseObject(mockValue) ? mockValue.toString() : JsonUtil.beanToJson(mockValue));
                    }
                }
                entity.setUnique(field == null ? UUID.randomUUID().toString() : StringUtil.toMD5(field.toGenericString()));
                RenewType renewType = this.filter.renewType(fieldExtra, null);
                entity.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
                entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
                result.add(entity);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public BeanReader getFilter() {
        return this.filter;
    }

    public void setFilter(BeanReader filter) {
        this.filter = filter;
    }

    public MockReader getMockFilter() {
        return this.mockFilter;
    }

    public void setMockFilter(MockReader mockFilter) {
        this.mockFilter = mockFilter;
    }

    public Set<String> getProjectBasePaths() {
        return this.projectBasePaths;
    }

    public void setProjectBasePaths(Set<String> projectBasePaths) {
        this.projectBasePaths = projectBasePaths;
    }

    public MethodExtra getMethodExtra() {
        return this.methodExtra;
    }

    public void setMethodExtra(MethodExtra methodExtra) {
        if (methodExtra == null) {
            return;
        }
        this.methodExtra = methodExtra;
    }
}

