/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BeanIgnoreCommentReader
extends HandlerChain<ModelFieldExtra, Boolean> {
    @Override
    public Boolean resolve(ModelFieldExtra extra, Boolean transfer) {
        Type type = extra.getFieldType();
        if (extra.getField() == null) {
            return this.nextHandler().resolve(extra, false);
        }
        Field field = extra.getField();
        if (type.equals(Serializable.class) || type.equals(HttpServletRequest.class) || type.equals(HttpServletResponse.class)) {
            return this.nextHandler().resolve(extra, true);
        }
        if ("serialVersionUID".equals(field.getName())) {
            return this.nextHandler().resolve(extra, true);
        }
        String typeName = type.getTypeName();
        if (typeName.startsWith("sun.")) {
            return this.nextHandler().resolve(extra, true);
        }
        if (type.equals(Class.class)) {
            return this.nextHandler().resolve(extra, true);
        }
        if (extra.getFieldComment() != null && !StringUtil.isEmpty(extra.getFieldComment().getComment())) {
            String groups = ApidocCommentUtil.getCommentValue(extra.getFieldComment().getComment(), "groups");
            if (StringUtil.isEmpty(groups) || !groups.startsWith("[") || !groups.endsWith("]")) {
                return this.nextHandler().resolve(extra, false);
            }
            String[] s = groups.substring(1, groups.length() - 1).split(",");
            InterfaceExtra interfaceExtra = extra.getMethodExtra().getInterfaceExtra();
            String path = interfaceExtra.getControllerExtra().getControllerClass().getCanonicalName() + "." + interfaceExtra.getMethod().getName();
            return this.nextHandler().resolve(extra, Stream.of(s).noneMatch(group -> ApidocCommentUtil.isMatchPath(group, path)));
        }
        return this.nextHandler().resolve(extra, false);
    }
}

