package cn.easyutil.easyapi.util.http;

import cn.easyutil.easyapi.util.StringUtil;

import java.util.Optional;
import java.util.stream.Stream;

public enum HttpMethod {
    GET,POST,DELETE,HEAD,OPTIONS,PATCH,PUT,TRACE;

    public static HttpMethod get(String method){
        if(StringUtil.isEmpty(method)){
            return GET;
        }
        final String find = method.toUpperCase().trim();
        Optional<HttpMethod> first = Stream.of(HttpMethod.values()).filter(e -> e.toString().equals(find)).findFirst();
        if(first.isPresent()){
            return first.get();
        }
        return GET;
    }
}
