package cn.easyutil.easyapi.parameterized;

import cn.easyutil.easyapi.util.ObjectUtil;

import java.lang.reflect.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 泛型工具类
 */
public class GenericTypeUtil {

    /**
     * 判断是否数组或集合类型
     */
    public static boolean isArray(Type type){
        if(type == null){
            return false;
        }
        if(type instanceof GenericArrayType){
            return true;
        }
        if(Class.class.isAssignableFrom(type.getClass())){
            Class typeClass = (Class) type;
            return typeClass.isArray() || Collection.class.isAssignableFrom(typeClass);
        }
        Class ownerClass = getOwnerClass(type);
        return ownerClass.isArray() || Collection.class.isAssignableFrom(ownerClass);
    }

    public static Class getArrayGenericClass(Type type){
        if(!isArray(type)){
            return type.getClass();
        }
        Class typeClass ;
        if(isGeneric(type)){
            GenericTypeBind binds = getGenericTypes(type);
            if(binds.size() > 1){
                return type.getClass();
            }
            Type bindType = binds.get(0);
            if(isGeneric(bindType)){
                return type.getClass();
            }
            typeClass = (Class) bindType;
        }else{
            typeClass = ((Class) type).getComponentType();
            if(typeClass == null){
                return Object.class;
            }
        }
        return typeClass;
    }

    /**
     * 判断是否是基础数据或集合类型
     * @param type
     * @return
     */
    public static boolean isBaseArray(Type type){

        return ObjectUtil.isBaseClass(getArrayGenericClass(type));
    }

    /**
     * 判断是否是泛型
     * @param type  类型
     * @return
     */
    public static boolean isGeneric(Type type){
        if(type == null){
            return false;
        }
        if(type instanceof ParameterizedType){
            return true;
        }
        if(type instanceof GenericArrayType){
            return true;
        }
        if(type instanceof TypeVariable){
            return true;
        }
        if(type instanceof WildcardType){
            return true;
        }
        return false;
    }

    /**
     * 获取泛型依赖的真实类型，比如List<T>，获取到List类型
     * @param type
     * @return
     */
    public static Class getOwnerClass(Type type){
        List<Class> ownerClass = new ArrayList<>();
        getOwnerClass(type, ownerClass);
        if(ownerClass.size() > 0){
            return ownerClass.get(0);
        }
        return null;
    }

    /**
     * 获取泛型依赖的真实类型，比如List<T>，获取到List类型
     * @param type
     * @param ownerClass
     */
    private static void getOwnerClass(Type type, List<Class> ownerClass){
        if(type == null){
            return ;
        }
        if(!isGeneric(type)){
            if(type instanceof Class){
                Class owner = (Class) type;
                if(owner.isArray()){
                    ownerClass.add(owner.getComponentType());
                }else{
                    ownerClass.add((Class)type);
                }
                return ;
            }
        }
        if(type instanceof ParameterizedType){
            Type ownerType = ((ParameterizedType) type).getRawType();
            getOwnerClass(ownerType, ownerClass);
        }
        if(type instanceof GenericArrayType){
            Type ownerType = ((GenericArrayType) type).getGenericComponentType();
            getOwnerClass(ownerType, ownerClass);
        }
        if(type instanceof WildcardType){
            Type[] upperBounds = ((WildcardType) type).getUpperBounds();
            if(upperBounds!=null && upperBounds.length>0){
                getOwnerClass(upperBounds[0], ownerClass);
            }
            //else情况待处理
        }
        if(type instanceof TypeVariable){
            Type[] bounds = ((TypeVariable) type).getBounds();
            if(bounds!=null && bounds.length>0){
                getOwnerClass(bounds[0], ownerClass);
            }
            //else情况待处理
        }
    }

    /**
     * 返回下表指定位置的泛型
     * @param type
     * @param index
     * @return
     */
    public static Type getGenericTypes(Type type,int index){
        GenericTypeBind binds = getGenericTypes(type);
        return binds.get(index);
    }

    public static GenericTypeBind getGenericTypes(Type type){
        GenericTypeBind bind = new GenericTypeBind();
        getGenericTypes(type,bind);
        return bind;
    }
    /**
     * 获取全部泛型类型
     * @param type
     * @return
     */
    private static void getGenericTypes(Type type,GenericTypeBind bind){
        if(type == null){
            return ;
        }
        if(!isGeneric(type)){
            return ;
        }
        if(type instanceof ParameterizedType){
            //actualTypeArguments
            Type[] arguments = ((ParameterizedType) type).getActualTypeArguments();
            Class rawType = (Class)((ParameterizedType) type).getRawType();
            TypeVariable[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; i++) {
                bind.bind(typeParameters[i].getTypeName(),arguments[i]);
            }
            return ;
        }
        if(type instanceof GenericArrayType){
            GenericArrayType arrayType = (GenericArrayType) type;
            Type genericType = arrayType.getGenericComponentType();
            getGenericTypes(genericType,bind);
        }
        if(type instanceof WildcardType){
            Type[] bounds = ((WildcardType) type).getLowerBounds();
            if(bounds.length == 0){
                bounds = ((WildcardType) type).getUpperBounds();
            }
            if(bounds.length == 0){
                bind.bind(type.getTypeName(), type);
                return ;
            }
            getGenericTypes(bounds[0], bind);
        }
        if(type instanceof TypeVariable){
            Type[] arguments = ((TypeVariable) type).getBounds();
            for (Type argument : arguments) {
                getGenericTypes(argument, bind);
            }
        }
    }
}
