package cn.easyutil.easyapi.javadoc.reader;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MethodComment  extends JavaSourceComment{

    private List<SourceParameterComment> parameters = new ArrayList<>();

    private String returnType;

    private String returnComment;

    public void addParameter(SourceParameterComment parameter){
        parameters.add(parameter);
    }

    public List<SourceParameterComment> getParameters() {
        return parameters;
    }

    public void setParameters(List<SourceParameterComment> parameters) {
        this.parameters = parameters;
    }

    public SourceParameterComment getParameter(String parameterName){
        Optional<SourceParameterComment> first = this.parameters.stream().filter(item -> item.getName().equals(parameterName)).findFirst();
        return first.orElseGet(SourceParameterComment::new);
    }

    public String getReturnType() {
        return returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getReturnComment() {
        return returnComment;
    }

    public void setReturnComment(String returnComment) {
        this.returnComment = returnComment;
    }
}
