package cn.easyutil.easyapi.hook;

import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;

public interface ApiRunAround {

    /**
     * 数据库和连接初始化完成
     */
    default void dataSourceInitialized(){};

    /**
     * 数据库创建完成
     */
    default void dbCreated(){};

    /**
     * 项目信息创建完成
     */
    default void projectInitialized(DBProjectEntity project){};

    /**
     * 数据库已清理完成
     */
    default void dbCleared(){};

    /**
     * 准备生成接口文档
     */
    default void beforeCreateApi(){};

    /**
     * 接口文档已生成
     */
    default void apiCreated(){};

}
