package cn.easyutil.easyapi.handler.reader.requests.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.util.AnnotationUtil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;

public class RequestDescriptionSwaggerReader extends HandlerChain<RequestExtra,String> {

    @Override
    public String resolve(RequestExtra extra, String transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        if(extra.getParameter()==null){
            return nextHandler().resolve(extra, transfer);
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiImplicitParams", extra.getParameter().getAnnotations());
        if(annotation == null){
            return nextHandler().resolve(extra, transfer);
        }
        Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
        if(value==null || !value.getClass().isArray()){
            return nextHandler().resolve(extra, transfer);
        }
        String parameterName = extra.getParameterName();
        int length = Array.getLength(value);
        for (int i = 0; i < length; i++) {
            Object o = Array.get(value, i);
            if(o==null || !o.getClass().isAnnotation()){
                continue;
            }
            Object name = AnnotationUtil.getAnnotationValue((Annotation) o, "name");
            if(name!=null && parameterName.equals(name.toString())){
                Object val = AnnotationUtil.getAnnotationValue((Annotation) o, "value");
                if(val != null){
                    return nextHandler().resolve(extra, val.toString());
                }
            }
        }
        return nextHandler().resolve(extra, transfer);
    }
}
