package cn.easyutil.easyapi.handler.reader.requests.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.RequestExtra;

public class RequestDescriptionApiReader extends HandlerChain<RequestExtra,String> {

    @Override
    public String resolve(RequestExtra extra, String transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        if(extra.getParameter() == null){
            return nextHandler().resolve(extra, transfer);
        }
        ApidocComment apidocComment = extra.getParameter().getDeclaredAnnotation(ApidocComment.class);
        if(apidocComment != null){
            return nextHandler().resolve(extra, apidocComment.value());
        }
        return nextHandler().resolve(extra, transfer);
    }
}
