package cn.easyutil.easyapi.handler.reader.requests;

import cn.easyutil.easyapi.handler.reader.requests.model.*;

public class DefaultRequestReaderHandler {

    public void addDefault(){
        addConditions();
        addDescriptions();
        addIgnores();
        addMockTemplates();
        addNames();
    }

    private void addNames(){
        RequestReaderHandler.addNameHandlers(new RequestNameCommentReader());
    }

    private void addMockTemplates(){
        RequestReaderHandler.addMockTemplateHandlers(new RequestMockTemplateCommentReader());
    }

    private void addIgnores(){
        RequestReaderHandler.addIgnoreHandlers(new RequestIgnoreCommentReader());
    }

    private void addDescriptions(){
        RequestReaderHandler.addDescriptionHandlers(new RequestDescriptionApiReader());
        RequestReaderHandler.addDescriptionHandlers(new RequestDescriptionSwaggerReader());
        RequestReaderHandler.addDescriptionHandlers(new RequestDescriptionCommentReader());

    }

    private void addConditions(){
        RequestReaderHandler.addConditionHandlers(new RequestConditionCommentReader());
    }
}
