package cn.easyutil.easyapi.handler.reader.controllers.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.javadoc.reader.CommentDetail;
import org.springframework.util.CollectionUtils;

import java.util.Optional;

public class ControllerIgnoreCommentReader extends HandlerChain<ControllerExtra,Boolean> {

    @Override
    public Boolean resolve(ControllerExtra extra, Boolean transfer) {
        ClassComment controllerComment = extra.getControllerComment();
        if(controllerComment==null || CollectionUtils.isEmpty(controllerComment.getCommentDetails())){
            return nextHandler().resolve(extra, transfer);
        }
        Optional<CommentDetail> apiNote = controllerComment.getCommentDetails().stream().filter(item -> item.getKey().equals("deprecated")).findFirst();
        return nextHandler().resolve(extra, apiNote.isPresent()?true:null);
    }
}
