package cn.easyutil.easyapi.handler.reader.controllers.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import cn.easyutil.easyapi.javadoc.reader.CommentDetail;
import cn.easyutil.easyapi.util.StringUtil;

import java.util.List;

public class ControllerAuthorCommentReader extends HandlerChain<ControllerExtra,String> {

    @Override
    public String resolve(ControllerExtra extra, String transfer) {
        if(extra.getControllerComment()==null || !StringUtil.isEmpty(transfer)){
            return nextHandler().resolve(extra, transfer);
        }
        if(!StringUtil.isEmpty(extra.getControllerComment().getComment())){
            String author = ApidocCommentUtil.getCommentValue(extra.getControllerComment().getComment(), "author");
            if(!StringUtil.isEmpty(author)){
                return nextHandler().resolve(extra, author);
            }
        }
        List<CommentDetail> details = extra.getControllerComment().getCommentDetails();
        if(details == null){
            return nextHandler().resolve(extra, transfer);
        }
        for (CommentDetail detail : details) {
            if(detail.getKey().contains("author")){
                return nextHandler().resolve(extra, detail.getValue());
            }
        }
        return nextHandler().resolve(extra, transfer);
    }
}
