package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.util.AnnotationUtil;

import java.lang.annotation.Annotation;

public class BeanShowSwaggerReader extends HandlerChain<ModelFieldExtra,Boolean> {

    @Override
    public Boolean resolve(ModelFieldExtra extra, Boolean transfer) {
        if(extra.getField() == null){
            return nextHandler().resolve(extra, true);
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", extra.getField().getAnnotations());
        if(annotation != null){
            Object hidden = AnnotationUtil.getAnnotationValue(annotation, "hidden");
            if(hidden instanceof Boolean){
                return nextHandler().resolve(extra, !((Boolean) hidden));
            }
        }
        return nextHandler().resolve(extra, true);
    }
}
