package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import org.springframework.web.multipart.MultipartFile;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

public class BeanJavaTypeCommentReader extends HandlerChain<ModelFieldExtra,JavaType> {

    @Override
    public JavaType resolve(ModelFieldExtra extra, JavaType transfer) {
        Type type = extra.getFieldType();
        if(type == null){
            return nextHandler().resolve(extra, transfer);
        }
        if(type.equals(BigDecimal.class)){
            return nextHandler().resolve(extra, JavaType.Long);
        }
        if(type.equals(Date.class) || type.equals(java.sql.Date.class) || type.equals(LocalDate.class) || type.equals(LocalDateTime.class)){
            return nextHandler().resolve(extra, JavaType.Long);
        }
        if(type instanceof Class){
            if(MultipartFile.class.isAssignableFrom((Class<?>) type)){
                return nextHandler().resolve(extra, JavaType.File);
            }
        }
        return nextHandler().resolve(extra, JavaType.getJavaTypeByType(type));
    }
}
