package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.util.StringUtil;

public class BeanDescriptionApiReader extends HandlerChain<ModelFieldExtra,String> {

    @Override
    public String resolve(ModelFieldExtra extra, String transfer) {
        if(extra.getField() == null){
            return nextHandler().resolve(extra, transfer);
        }
        ApidocComment api = extra.getField().getDeclaredAnnotation(ApidocComment.class);
        if(api!=null && !StringUtil.isEmpty(api.value())){
            return nextHandler().resolve(extra, api.value());
        }
        return nextHandler().resolve(extra, transfer);
    }
}
