package cn.easyutil.easyapi.handler.operator.provide;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.*;
import cn.easyutil.easyapi.handler.extra.MethodExtra;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.handler.operator.BeanReader;
import cn.easyutil.easyapi.handler.reader.beans.*;
import cn.easyutil.easyapi.handler.reader.mocks.MockReaderHandler;
import cn.easyutil.easyapi.logic.creator.ApiEmptyObj;
import cn.easyutil.easyapi.logic.creator.FieldParam;
import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BeanReaderProvider implements BeanReader {

    @Override
    public List<String> conditions(ModelFieldExtra extra, List<String> transfer) {
        HandlerChain<ModelFieldExtra,List<String>> start = MockReaderHandler.useFirst(BeanReaderHandler.getConditionHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(new ArrayList<>());
    }

    @Override
    public String description(ModelFieldExtra extra, String transfer) {
        HandlerChain<ModelFieldExtra,String> start = MockReaderHandler.useFirst(BeanReaderHandler.getDescriptionHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse("");
    }

    @Override
    public Boolean ignore(ModelFieldExtra extra, Boolean transfer) {
        HandlerChain<ModelFieldExtra,Boolean> start = MockReaderHandler.useFirst(BeanReaderHandler.getIgnoreHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(false);
    }

    @Override
    public JavaType javaType(ModelFieldExtra extra, JavaType transfer) {
        HandlerChain<ModelFieldExtra,JavaType> start = MockReaderHandler.useFirst(BeanReaderHandler.getJavaTypeHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(JavaType.Map);
    }

    @Override
    public String mockTemplate(ModelFieldExtra extra, String transfer) {
        HandlerChain<ModelFieldExtra,String> start = MockReaderHandler.useFirst(BeanReaderHandler.getMockTemplateHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse("");
    }

    @Override
    public String name(ModelFieldExtra extra, String transfer) {
        Field field = extra.getField();
        HandlerChain<ModelFieldExtra,String> start = MockReaderHandler.useFirst(BeanReaderHandler.getNameHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(field!=null?field.getName():"");
    }

    @Override
    public List<FieldParam> params(ModelFieldExtra extra, List<FieldParam> transfer) {
        HandlerChain<ModelFieldExtra,List<FieldParam>> start = MockReaderHandler.useFirst(BeanReaderHandler.getParamHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(new ArrayList<>());
    }

    @Override
    public RenewType renewType(ModelFieldExtra extra, RenewType transfer) {
        HandlerChain<ModelFieldExtra,RenewType> start = MockReaderHandler.useFirst(BeanReaderHandler.getRenewTypeHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(RenewType.increment);
    }

    @Override
    public Boolean required(ModelFieldExtra extra, Boolean transfer) {
        HandlerChain<ModelFieldExtra,Boolean> start = MockReaderHandler.useFirst(BeanReaderHandler.getRequiredHandlers());
        Boolean resolve = start.resolve(extra, transfer);
        if(resolve != null){
            return resolve;
        }
        if(extra.getFieldComment()!=null && !StringUtil.isEmpty(extra.getFieldComment().getComment())){
            String required = ApidocCommentUtil.getCommentValue(extra.getFieldComment().getComment(), "required");
            if(!StringUtil.isEmpty(required)){
                return "true".equalsIgnoreCase(required);
            }
        }
        return true;
    }

    @Override
    public Boolean show(ModelFieldExtra extra, Boolean transfer) {
        HandlerChain<ModelFieldExtra,Boolean> start = MockReaderHandler.useFirst(BeanReaderHandler.getShowHandlers());
        Boolean resolve = start.resolve(extra, transfer);
        if(resolve != null){
            return resolve;
        }
        if(extra.getFieldComment()!=null && !StringUtil.isEmpty(extra.getFieldComment().getComment())){
            String hidden = ApidocCommentUtil.getCommentValue(extra.getFieldComment().getComment(), "hidden");
            if(!StringUtil.isEmpty(hidden)){
                return "false".equalsIgnoreCase(hidden);
            }
        }
        return true;
    }

    @Override
    public Type type(ModelFieldExtra extra, Type transfer) {
        Field field = extra.getField();
        HandlerChain<ModelFieldExtra,Type> start = MockReaderHandler.useFirst(BeanReaderHandler.getTypeHandlers());
        return Optional.ofNullable(start.resolve(extra, transfer)).orElse(field!=null?field.getGenericType(): ApiEmptyObj.class);
    }
}
