package cn.easyutil.easyapi.handler;

import cn.easyutil.easyapi.handler.extra.ApiExtra;
import org.springframework.util.CollectionUtils;

import java.util.List;

public class BaseHandlerChain {

    protected static <E extends ApiExtra,T> void addChain(List<HandlerChain<E,T>> list, HandlerChain<E,T> handler){
        if(!list.isEmpty()){
            HandlerChain<E ,T> chain = list.get(list.size() - 1);
            chain.setNext(handler);
        }
        list.add(handler);
    }

    public static <E extends ApiExtra,T> HandlerChain<E,T> useFirst(List<HandlerChain<E,T>> list){
        if(!CollectionUtils.isEmpty(list)){
            return list.get(0);
        }
        return HandlerChain.none;
    }
}
