package cn.easyutil.easyapi.content;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.handler.operator.provide.*;
import cn.easyutil.easyapi.logic.creator.MethodParam;

import java.util.*;

/**
 * 接口文档生成时需要使用到的变量
 */
public class ProjectContext {

    /**
     * 项目根目录
     */
    public static Set<String> projectBasePath = new HashSet<>();

    /**
     * 没有key的参数默认key
     */
    public static final String nullKey = "_null";

    public static DBProjectEntity currentProject;

    public static Long currentProjectId = null;

    public static Long currentModuleId = null;

    public static String currentProjectName = null;

    public static String currentModuleName = null;

    public static AllConfiguration allConfiguration;

    public static ControllerReaderProvider controllerOperator;

    public static InterfaceReaderProvider interfaceOperator;

    public static BeanReaderProvider beanOperator;

    public static MockReaderProvider mockTemplateOperator;

    public static RequestReaderProvider requestOperator;

    public static ResponseReaderProvider responseOperator;

    /** 全局统一接口返回类型*/
    public static List<MethodParam> globalResponseParams;

    /** 全局统一接口请求类型*/
    public static List<MethodParam> globalRequestParams;



    public static String javaMockRemark(){
        return "java mock字段表达式" + newLine() +
                "${char}:默认4个随机数字+字母" + newLine() +
                "${char(name)}:随机一个中文昵称" + newLine() +
                "${char(text)}:随机一个中文文本内容" + newLine() +
                "${char(ho)}:随机一个公司名称" + newLine() +
                "${char(address)}:随机一个中文地址" + newLine() +
                "${char(mobile)}:随机一个手机号码" + newLine() +
                "${char(md5)}:随机一个md5串" + newLine() +
                "${char(aes)}:随机一个aes串" + newLine() +
                "${int}:随机取0或1" + newLine() +
                "${int(10)}:随机取0-10之间的数字,范围可自定义" + newLine() +
                "${int(1,10)}:随机取1-10之间的数字,范围可自定义" + newLine() +
                "${double}:随机取0到1之间的小数，保留2位" + newLine() +
                "${double(10)}:随机取0到10之间的小数，保留2位,范围可自定义" + newLine() +
                "${double(1,10)}:随机取1到10之间的小数，保留2位,范围可自定义" + newLine() +
                "${time}:取当前时间戳，13位" + newLine() +
                "${time()}:当前时间转换字符串，默认yyyy-MM-dd HH:mm:ss" + newLine() +
                "${time(yyyy-MM-dd HH:mm:ss)}:当前时间转换字符串，表达式可自定义" + newLine() +
                "${url}:随机一个图片网络地址" + newLine() +
                "${url(pic)}:随机一个图片网络地址" + newLine() +
                "${url(vod)}:随机一个视频网络地址" + newLine();
    }

    private static String newLine() {
        return "</br>";
    }
}
