/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.configuration.EasyApiGlobalRequestConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiGlobalResponseConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.handler.extra.MethodExtra;
import cn.easyutil.easyapi.handler.extra.MockExtra;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.handler.extra.ResponseExtra;
import cn.easyutil.easyapi.handler.operator.MockReader;
import cn.easyutil.easyapi.handler.operator.RequestReader;
import cn.easyutil.easyapi.handler.operator.ResponseReader;
import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.util.UncertainParamParser;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.util.CollectionUtils;

public class MethodParamsCreator {
    private Class<?> clazz;
    private Method method;
    private RequestReader reqFilter;
    private ResponseReader resFilter;
    private MockReader mockFilter;
    private List<DocParamEntity> requestParameters = new ArrayList<DocParamEntity>();
    private List<DocParamEntity> returnParameter = new ArrayList<DocParamEntity>();
    private String responseMock = "";
    private String requestMock = "";
    private InterfaceExtra interfaceExtra;

    private MethodParamsCreator() {
    }

    public static MethodParamsCreator build(InterfaceExtra interfaceExtra) {
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.interfaceExtra = interfaceExtra;
        creator.clazz = interfaceExtra.getControllerExtra().getControllerClass();
        creator.method = interfaceExtra.getMethod();
        creator.reqFilter = ProjectContext.requestOperator;
        creator.resFilter = ProjectContext.responseOperator;
        creator.mockFilter = ProjectContext.mockTemplateOperator;
        return creator;
    }

    public MethodParamsCreator create() {
        try {
            this.createParameters();
            this.createReturnType();
            MockProcess2 mocker = MockProcess2.with(this.mockFilter);
            mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
            Object req = mocker.mockByApiParams(this.requestParameters);
            Object res = mocker.mockByApiParams(this.returnParameter);
            this.requestMock = ObjectUtil.isBaseObject(req) ? req.toString() : JsonUtil.beanToJson(req);
            this.responseMock = ObjectUtil.isBaseObject(res) ? res.toString() : JsonUtil.beanToJson(res);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("\u63a5\u53e3\u53c2\u6570\u6784\u5efa\u5931\u8d25:" + this.clazz.getCanonicalName() + "." + this.method.getName());
        }
    }

    private DocParamEntity createResponseDoc(MethodParam param, ResponseExtra responseExtra) {
        if (this.resFilter.ignore(responseExtra, null).booleanValue()) {
            return null;
        }
        String description = this.resFilter.description(responseExtra, null);
        JavaType javaType = JavaType.getJavaTypeByType(param.getParamType());
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(description);
        entity.setMockTemplate(this.resFilter.mockTemplate(responseExtra, null));
        entity.setClassName(param.getParamType().getTypeName());
        entity.setRequired(this.resFilter.required(responseExtra, null) != false ? 1 : 0);
        entity.setShow(this.resFilter.show(responseExtra, null) != false ? 1 : 0);
        entity.setJavaType(javaType.getType());
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(param.getParamType());
        bind.binds(param.getBind());
        this.createParam(param.getParamType(), entity, bind, responseExtra);
        return entity;
    }

    private DocParamEntity createRequestDoc(MethodParam param, RequestExtra requestExtra) {
        String paramName = this.reqFilter.name(requestExtra, param.getParamName());
        Type paramType = this.reqFilter.type(requestExtra, param.getParamType());
        Class ownerClass = GenericTypeUtil.getOwnerClass(paramType);
        if (this.reqFilter.ignore(requestExtra, null).booleanValue()) {
            return null;
        }
        if (paramType == null || ownerClass == null) {
            return null;
        }
        String description = this.reqFilter.description(requestExtra, null);
        if (StringUtil.isEmpty(description)) {
            description = requestExtra.getInterfaceExtra().getMethodComment().getParameter(paramName).getComment();
        }
        JavaType javaType = JavaType.getJavaTypeByType(paramType);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(description);
        entity.setMockTemplate(this.reqFilter.mockTemplate(requestExtra, null));
        entity.setName(paramName);
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setRequired(this.reqFilter.required(requestExtra, null) != false ? 1 : 0);
        entity.setShow(this.reqFilter.show(requestExtra, null) != false ? 1 : 0);
        entity.setJavaType(javaType.getType());
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(paramType);
        bind.binds(param.getBind());
        this.createParam(paramType, entity, bind, requestExtra);
        return entity;
    }

    private void deepCreateParameters(List<MethodParam> params, List<DocParamEntity> result, String originalParameterName, RequestExtra requestExtra, boolean enableGlobal) {
        UncertainParamParser util = null;
        MethodComment methodComment = requestExtra.getInterfaceExtra().getMethodComment();
        ClassComment controllerComment = requestExtra.getInterfaceExtra().getControllerExtra().getControllerComment();
        if (methodComment != null) {
            util = UncertainParamParser.builder(this.clazz, this.method, controllerComment, methodComment);
        }
        for (MethodParam param : params) {
            DocParamEntity createParams = this.createRequestDoc(param, requestExtra);
            if (createParams == null) continue;
            if (CollectionUtils.isEmpty(createParams.getChildren())) {
                result.add(createParams);
                continue;
            }
            if (util != null && originalParameterName != null) {
                for (DocParamEntity doc : createParams.getChildren()) {
                    MethodParam docParam = null;
                    if (doc.getJavaType().equals(JavaType.Map.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestMapField(originalParameterName, doc.getName());
                    }
                    if (doc.getJavaType().equals(JavaType.Object.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestObjField(originalParameterName, doc.getName());
                    }
                    if (docParam == null) continue;
                    if (CollectionUtils.isEmpty(docParam.getChildren())) {
                        DocParamEntity doc1 = this.createRequestDoc(docParam, requestExtra);
                        if (doc1 == null) continue;
                        String name = doc.getName();
                        BeanUtils.copyProperties((Object)doc1, (Object)doc);
                        doc.setName(name);
                        continue;
                    }
                    List children = Optional.ofNullable(param.getChildren()).orElse(new ArrayList());
                    children.addAll(docParam.getChildren());
                    param.setChildren(children);
                }
                if (GenericTypeUtil.isArray(requestExtra.getType())) {
                    createParams.setName("_null");
                    result.add(createParams);
                } else if (enableGlobal) {
                    result.add(createParams);
                } else {
                    result.addAll(createParams.getChildren());
                }
            }
            if (CollectionUtils.isEmpty(param.getChildren())) continue;
            List children = Optional.ofNullable(createParams.getChildren()).orElse(new ArrayList());
            this.deepCreateParameters(param.getChildren(), children, null, requestExtra, enableGlobal);
            createParams.setChildren(children);
            if (originalParameterName != null) {
                result.addAll(children);
                continue;
            }
            result.add(createParams);
        }
    }

    private List<MethodParam> createParams(RequestExtra requestExtra) {
        String parameterName = requestExtra.getParameterName();
        Type parameterType = requestExtra.getType();
        MethodParam param = new MethodParam();
        param.setParamType(parameterType);
        param.setParamName(parameterName);
        Class ownerClass = GenericTypeUtil.getOwnerClass(parameterType);
        if (ownerClass == null) {
            return new ArrayList<MethodParam>();
        }
        UncertainParamParser util = null;
        MethodComment methodComment = requestExtra.getInterfaceExtra().getMethodComment();
        ClassComment controllerComment = requestExtra.getInterfaceExtra().getControllerExtra().getControllerComment();
        if (methodComment != null) {
            util = UncertainParamParser.builder(this.clazz, this.method, controllerComment, methodComment);
        }
        if (Map.class.isAssignableFrom(ownerClass)) {
            if (util == null) {
                return Collections.singletonList(param);
            }
            MethodParam mapParam = util.parseRequestMap(parameterName);
            if (mapParam == null) {
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(mapParam.getChildren()).orElse(Collections.emptyList());
        }
        if (Object.class.equals((Object)ownerClass)) {
            if (util == null) {
                return Collections.singletonList(param);
            }
            MethodParam objParam = util.parseRequestObj(parameterName);
            if (objParam == null) {
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(objParam.getChildren()).orElse(Collections.emptyList());
        }
        return Collections.singletonList(param);
    }

    private void createParameters() {
        Parameter[] parameters = this.method.getParameters();
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discover.getParameterNames(this.method);
        if (parameters == null || parameters.length == 0) {
            return;
        }
        if (parameterNames == null || parameterNames.length == 0) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            String globalFieldName;
            EasyApiGlobalRequestConfiguration reqConf;
            Class<?> globalType;
            List<MethodParam> process;
            MethodParam param = new MethodParam();
            String parameterName = parameterNames[i];
            Type parameterType = parameters[i].getParameterizedType();
            param.setParameter(parameters[i]);
            RequestExtra requestExtra = new RequestExtra(this.interfaceExtra);
            requestExtra.setParameter(parameters[i]);
            requestExtra.setParameterName(parameterName);
            requestExtra.setType(parameterType);
            requestExtra.setTypeBind(GenericTypeUtil.getGenericTypes(requestExtra.getType()));
            parameterName = this.reqFilter.name(requestExtra, null);
            if (StringUtil.isEmpty(param.getParamName())) {
                param.setParamName(parameterNames[i]);
            }
            requestExtra.setParameterName(parameterName);
            param.setParamName(parameterName);
            parameterType = this.reqFilter.type(requestExtra, null);
            param.setParamType(parameterType);
            requestExtra.setType(parameterType);
            requestExtra.setTypeBind(GenericTypeUtil.getGenericTypes(requestExtra.getType()));
            ArrayList<DocParamEntity> result = new ArrayList<DocParamEntity>();
            List<MethodParam> params = this.createParams(requestExtra);
            this.reqFilter.params(requestExtra, null);
            boolean enableGlobal = false;
            if (parameters.length == 1 && !CollectionUtils.isEmpty(ProjectContext.globalRequestParams) && (process = this.globalParamProcess(param, globalType = (reqConf = ProjectContext.allConfiguration.getGlobalRequestConfiguration()).getRequestType(), globalFieldName = reqConf.getFieldName(), ProjectContext.globalRequestParams, reqConf.getExcludeMethods(), reqConf.getIncludeMethods())) != null) {
                params = process;
                enableGlobal = true;
            }
            this.deepCreateParameters(params, result, parameterNames[i], requestExtra, enableGlobal);
            this.requestParameters.addAll(result);
        }
    }

    private DocParamEntity deepCreateReturnType(MethodParam param) {
        Type type = param.getParamType();
        if (type == Void.TYPE) {
            return null;
        }
        Class ownerClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        bind.binds(param.getBind());
        ResponseExtra responseExtra = new ResponseExtra(this.interfaceExtra);
        responseExtra.setType(type);
        responseExtra.setTypeBind(bind);
        if (type == null || ownerClass == null) {
            return null;
        }
        if (this.resFilter.ignore(responseExtra, null).booleanValue()) {
            return null;
        }
        JavaType javaType = JavaType.getJavaTypeByType(type);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(this.resFilter.description(responseExtra, null));
        entity.setMockTemplate(this.resFilter.mockTemplate(responseExtra, null));
        entity.setRequired(this.resFilter.required(responseExtra, null) != false ? 1 : 0);
        entity.setShow(this.resFilter.show(responseExtra, null) != false ? 1 : 0);
        entity.setName("_null");
        if (!StringUtil.isEmpty(param.getParamName())) {
            entity.setName(param.getParamName());
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        this.createParam(type, entity, bind, responseExtra);
        entity.setChildren(entity.getChildren() == null ? new ArrayList<DocParamEntity>() : new ArrayList<DocParamEntity>(entity.getChildren()));
        return entity;
    }

    private List<DocParamEntity> mapOrObject(DocParamEntity doc, UncertainParamParser util, boolean isField, ResponseExtra responseExtra) {
        if (doc == null) {
            return null;
        }
        if (util != null) {
            List<MethodParam> uncertains = null;
            if (doc.getJavaType().equals(JavaType.Map.getType())) {
                MethodParam mapParam = util.parseResponseMapField(doc.getName());
                if (!isField) {
                    mapParam = util.parseResponseMap();
                }
                if (mapParam != null && mapParam.getChildren() != null) {
                    uncertains = mapParam.getChildren();
                }
            }
            if (!StringUtil.isEmpty(doc.getClassName()) && doc.getClassName().contains("java.lang.Object")) {
                MethodParam objParam = util.parseResponseObjField(doc.getName());
                if (!isField) {
                    objParam = util.parseResponseObj();
                }
                if (objParam != null) {
                    uncertains = objParam.getChildren();
                }
            }
            if (uncertains != null) {
                for (MethodParam uncertain : uncertains) {
                    DocParamEntity childrenDoc = this.createResponseDoc(uncertain, responseExtra);
                    if (childrenDoc == null) continue;
                    ArrayList<DocParamEntity> children = Optional.ofNullable(doc.getChildren()).orElse(new ArrayList());
                    children = new ArrayList<DocParamEntity>(children);
                    children.add(childrenDoc);
                    return children;
                }
            }
        }
        return null;
    }

    private void deepCreateReturnType(List<MethodParam> types, List<DocParamEntity> result, ResponseExtra modelExtra) {
        UncertainParamParser util = null;
        MethodComment methodComment = modelExtra.getInterfaceExtra().getMethodComment();
        ClassComment controllerComment = modelExtra.getInterfaceExtra().getControllerExtra().getControllerComment();
        if (methodComment != null) {
            util = UncertainParamParser.builder(this.clazz, this.method, controllerComment, methodComment);
        }
        for (MethodParam param : types) {
            DocParamEntity document = this.deepCreateReturnType(param);
            if (document == null) continue;
            List children = Optional.ofNullable(document.getChildren()).orElse(new ArrayList());
            List<DocParamEntity> mapChildren = this.mapOrObject(document, util, false, modelExtra);
            if (!CollectionUtils.isEmpty(mapChildren)) {
                children.addAll(mapChildren);
            }
            document.setChildren(children);
            for (DocParamEntity doc : children) {
                List<DocParamEntity> docMapChildren = this.mapOrObject(doc, util, true, modelExtra);
                if (CollectionUtils.isEmpty(docMapChildren)) continue;
                ArrayList<DocParamEntity> docChildren = doc.getChildren() == null ? new ArrayList<DocParamEntity>() : new ArrayList<DocParamEntity>(doc.getChildren());
                docChildren.addAll(docMapChildren);
                doc.setChildren(docChildren);
            }
            if (!CollectionUtils.isEmpty(param.getChildren())) {
                ArrayList<DocParamEntity> cr = new ArrayList<DocParamEntity>();
                this.deepCreateReturnType(param.getChildren(), cr, modelExtra);
                children.addAll(cr);
            }
            document.setChildren(children);
            result.add(document);
        }
    }

    private void createReturnType() {
        String globalFieldName;
        EasyApiGlobalResponseConfiguration resConf;
        Class<?> globalType;
        MethodParam param;
        List<MethodParam> process;
        ResponseExtra responseExtra = new ResponseExtra(this.interfaceExtra);
        responseExtra.setType(this.method.getGenericReturnType());
        responseExtra.setTypeBind(GenericTypeUtil.getGenericTypes(responseExtra.getType()));
        List<MethodParam> types = this.resFilter.returnType(responseExtra, null);
        if (types == null) {
            return;
        }
        if (types.size() == 1 && !CollectionUtils.isEmpty(ProjectContext.globalResponseParams) && (process = this.globalParamProcess(param = types.get(0), globalType = (resConf = ProjectContext.allConfiguration.getGlobalResponseConfiguration()).getReturnType(), globalFieldName = resConf.getFieldName(), ProjectContext.globalResponseParams, resConf.getExcludeMethods(), resConf.getIncludeMethods())) != null) {
            types = process;
        }
        ArrayList<DocParamEntity> result = new ArrayList<DocParamEntity>();
        this.deepCreateReturnType(types, result, responseExtra);
        if (result.isEmpty()) {
            return;
        }
        if (GenericTypeUtil.isArray(responseExtra.getType())) {
            ((DocParamEntity)result.get(0)).setName("_null");
            this.returnParameter.addAll(result);
            return;
        }
        Integer javaType = ((DocParamEntity)result.get(0)).getJavaType();
        if (javaType.equals(JavaType.Object.getType())) {
            this.returnParameter.addAll(((DocParamEntity)result.get(0)).getChildren());
        } else {
            this.returnParameter.addAll(result);
        }
    }

    private List<MethodParam> globalParamProcess(MethodParam param, Class<?> globalType, String globalFieldName, List<MethodParam> globalParams, Set<String> excludeMethods, Set<String> includeMethods) {
        if (excludeMethods.stream().noneMatch(ex -> ApidocCommentUtil.isMatchPath(ex, this.method.toGenericString())) && includeMethods.stream().anyMatch(in -> ApidocCommentUtil.isMatchPath(in, this.method.toGenericString()))) {
            HashSet<String> globalIgnoreFields = new HashSet<String>();
            globalIgnoreFields.add(globalFieldName);
            globalIgnoreFields.add("serialVersionUID");
            if (param.getParamType() == null || !globalType.equals(GenericTypeUtil.getOwnerClass(param.getParamType()))) {
                param.setParamName(globalFieldName);
                globalParams.removeIf(next -> globalIgnoreFields.contains(next.getParamName()));
                globalParams.add(param);
                return globalParams;
            }
        }
        return null;
    }

    private void createParam(Type type, DocParamEntity entity, GenericTypeBind bind, MethodExtra methodExtra) {
        JavaType javaType = JavaType.getType(entity.getJavaType());
        Class ownerClass = GenericTypeUtil.getOwnerClass(type);
        if (ownerClass == null) {
            return;
        }
        if (ownerClass.isEnum()) {
            entity.setJavaType(JavaType.String.getType());
            Map<String, List<String>> enumFields = ObjectUtil.getEnumFields(ownerClass);
            entity.setJavaType(JavaType.String.getType());
            entity.setMockTemplate(enumFields.keySet().iterator().next());
            entity.setMockValue(enumFields.keySet().iterator().next());
            entity.setDescription(entity.getDescription() + "=>" + String.join((CharSequence)",", enumFields.keySet()));
            return;
        }
        JavaBeanCreator javaBeanCreator = JavaBeanCreator.builder(methodExtra);
        HashMap<String, List<DocParamEntity>> exists = new HashMap<String, List<DocParamEntity>>();
        if (javaType == JavaType.Object) {
            entity.setChildren(javaBeanCreator.readBean(type, bind, exists));
            return;
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType) {
            case Array: {
                entity.setChildren(javaBeanCreator.readArray(type, bind));
                break;
            }
            case ArrayObject: {
                entity.setChildren(javaBeanCreator.readArrayObject(type, bind, exists));
            }
        }
        MockExtra mockExtra = new MockExtra();
        mockExtra.setJavaType(javaType);
        mockExtra.setTemplate(entity.getMockTemplate());
        Object mockValue = this.mockFilter.mock(mockExtra, null);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        String uniqueStr = this.method.getDeclaringClass().getCanonicalName() + this.method.toGenericString() + entity.getClassName() + entity.getName();
        entity.setUnique(StringUtil.toMD5(uniqueStr));
        entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
        entity.setRenewType(RenewType.increment.getType());
    }

    public List<DocParamEntity> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return this.returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return this.responseMock;
    }

    public String getRequestMock() {
        return this.requestMock;
    }
}

