/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.task;

import cn.easyutil.easyapi.entity.db.auth.DBDictEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.interview.dto.OpenSyncDto;
import cn.easyutil.easyapi.interview.entity.ResponseBody;
import cn.easyutil.easyapi.interview.entity.UnifiedAccessDto;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.DictService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.task.SyncBody;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpImplEnum;
import cn.easyutil.easyapi.util.http.HttpMethod;
import cn.easyutil.easyapi.util.http.HttpOperation;
import cn.easyutil.easyapi.util.http.HttpRes;
import cn.easyutil.easyapi.util.http.HttpUtilFactory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SyncTask {
    private static final ControllerService controllerService = new ControllerService();
    private static final InterfaceService interfaceService = new InterfaceService();
    private static final InterfaceParamService paramService = new InterfaceParamService();
    private static final ProjectService projectService = new ProjectService();
    private static final DictService dictService = new DictService();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadWait() {
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @PostConstruct
    private void doTask() {
        new Thread(() -> {
            while (true) {
                DBDictEntity status = dictService.getByKey(DBDictEntity.syncStatusKey());
                DBDictEntity info = dictService.getByKey(DBDictEntity.syncInfoKey());
                if (status == null || status.getDictVal().equals("0")) {
                    SyncTask.threadWait();
                    continue;
                }
                if (info == null || StringUtil.isEmpty(info.getDictVal())) {
                    SyncTask.threadWait();
                    continue;
                }
                DBDictEntity dict = dictService.getByKey(DBDictEntity.syncInterfacesKey());
                if (dict == null) {
                    dict = new DBDictEntity();
                    dict.setDictKey(DBDictEntity.syncInterfacesKey());
                    dict.setDictVal("[]");
                    dict.setRemark("\u5df2\u7ecf\u540c\u6b65\u7684\u63a5\u53e3\u96c6\u5408");
                    dictService.save(dict);
                }
                DBProjectEntity project = (DBProjectEntity)projectService.getOne((Wrapper)Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getDefaultStatus, (Object)1));
                List<Long> ignoreIds = JsonUtil.jsonToList(dict.getDictVal(), Long.class);
                List<DBModuleInterfaceEntity> interfaces = interfaceService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).notIn(BaseDbEntity::getId, ignoreIds)).eq(BaseDbEntity::getProjectId, (Object)project.getId()));
                if (CollectionUtils.isEmpty((Collection)interfaces)) {
                    interfaces = Collections.emptyList();
                }
                OpenSyncDto dto = JsonUtil.jsonToBean(info.getDictVal(), OpenSyncDto.class);
                for (DBModuleInterfaceEntity anInterface : interfaces) {
                    status = dictService.getByKey(DBDictEntity.syncStatusKey());
                    if (status == null || status.getDictVal().equals("0")) break;
                    if (!SyncTask.doSync(anInterface, dto)) {
                        try {
                            Thread.sleep(30000L);
                            if (!SyncTask.doSync(anInterface, dto)) {
                                break;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    ignoreIds.add(anInterface.getId());
                    dict.setDictVal(JsonUtil.beanToJson(ignoreIds));
                    dictService.updateById(dict);
                }
                if (status != null) {
                    status.setDictVal("0");
                    dictService.updateById(status);
                }
                SyncTask.threadWait();
            }
        }).start();
    }

    private static boolean doSync(DBModuleInterfaceEntity anInterface, OpenSyncDto dto) {
        DBModuleControllerEntity controllerEntity = (DBModuleControllerEntity)controllerService.getById(anInterface.getControllerId());
        DBInterfaceParamEntity query = new DBInterfaceParamEntity();
        query.setInterfaceId(anInterface.getId());
        query = (DBInterfaceParamEntity)paramService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query), false);
        SyncBody body = new SyncBody();
        body.setController(controllerEntity);
        body.setInterfaces(anInterface);
        body.setParams(query);
        return SyncTask.doSync(body, dto);
    }

    private static boolean doSync(SyncBody body, OpenSyncDto dto) {
        body.setSecret(dto.getSecret());
        body.setUnique(dto.getProjectUnique());
        body.setName(dto.getProjectName());
        UnifiedAccessDto request = new UnifiedAccessDto();
        request.setApi("project::receiveSync");
        request.setBody(JsonUtil.beanToJson(body));
        HttpOperation operation = HttpUtilFactory.create(HttpImplEnum.httpClient);
        operation.getHttpReq().setUrl(dto.getAddress() + "/easyapi/doc/unified/post");
        operation.parameter(JsonUtil.beanToJson(request));
        operation.method(HttpMethod.POST);
        HttpRes res = operation.doUrl();
        return res.getResponseCode().equals(200) && !StringUtil.isEmpty(res.getResponseMsg()) && JsonUtil.jsonToBean(res.getResponseMsg(), ResponseBody.class).getCode().equals(200);
    }
}

