/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.mybatis;

import cn.easyutil.easyapi.mybatis.SqlExecMapper;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import javax.sql.DataSource;
import org.apache.ibatis.logging.nologging.NoLoggingImpl;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

public class MybatisUtil {
    private static SqlSessionManager sqlSessionManager = null;

    public static synchronized <T> void init(DataSource dataSource, boolean showSql, Class<?> ... mappers) {
        if (sqlSessionManager == null) {
            MybatisSqlSessionFactoryBean mfb = new MybatisSqlSessionFactoryBean();
            mfb.setDataSource(dataSource);
            MybatisConfiguration conf = new MybatisConfiguration();
            conf.setLogImpl(NoLoggingImpl.class);
            if (showSql) {
                conf.setLogImpl(StdOutImpl.class);
            }
            Environment env = new Environment.Builder("datasource").dataSource(dataSource).transactionFactory((TransactionFactory)new JdbcTransactionFactory()).build();
            conf.setEnvironment(env);
            mfb.setConfiguration(conf);
            conf.setMapUnderscoreToCamelCase(true);
            MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
            interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.H2));
            mfb.setPlugins(new Interceptor[]{interceptor});
            GlobalConfig defaults = GlobalConfigUtils.defaults();
            defaults.setBanner(false);
            mfb.setGlobalConfig(defaults);
            for (Class<?> mapper : mappers) {
                conf.addMapper(mapper);
            }
            conf.addMapper(SqlExecMapper.class);
            try {
                sqlSessionManager = SqlSessionManager.newInstance((SqlSessionFactory)mfb.getObject());
            }
            catch (Exception e) {
                sqlSessionManager = null;
            }
        }
    }

    public static <T> T getMapper(Class<T> clazz) {
        return (T)sqlSessionManager.getMapper(clazz);
    }
}

