/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.ApiCreateStep;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.operator.ReadBeanOperator;
import cn.easyutil.easyapi.filter.operator.ReadMockTemplateOperator;
import cn.easyutil.easyapi.filter.operator.ReadRequestOperator;
import cn.easyutil.easyapi.filter.operator.ReadResponseOperator;
import cn.easyutil.easyapi.javadoc.util.UncertainParamParser;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import cn.easyutil.easyapi.logic.creator.MethodParam;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.util.CollectionUtils;

public class MethodParamsCreator {
    private Class clazz;
    private Method method;
    private ApiExtra extra;
    private ReadRequestOperator reqFilter = new ReadRequestOperator(null);
    private ReadResponseOperator resFilter = new ReadResponseOperator(null);
    private ReadBeanOperator javaBeanApiFilter = new ReadBeanOperator(null);
    private ReadMockTemplateOperator mockFilter = new ReadMockTemplateOperator(null);
    private List<DocParamEntity> requestParameters = new ArrayList<DocParamEntity>();
    private List<DocParamEntity> returnParameter = new ArrayList<DocParamEntity>();
    private String responseMock = "";
    private String requestMock = "";
    private JavaBeanCreator javaBeanCreator;

    public static MethodParamsCreator build(Class clazz, Method method) {
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.method = method;
        creator.clazz = clazz;
        return creator;
    }

    public MethodParamsCreator withClass(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public MethodParamsCreator withMockFilter(ReadMockTemplateOperator mockFilter) {
        this.mockFilter = mockFilter;
        return this;
    }

    public MethodParamsCreator withReqFilter(ReadRequestOperator reqFilter) {
        this.reqFilter = reqFilter;
        return this;
    }

    public MethodParamsCreator withResFilter(ReadResponseOperator resFilter) {
        this.resFilter = resFilter;
        return this;
    }

    public MethodParamsCreator withBeanFilter(ReadBeanOperator beanFilter) {
        this.javaBeanApiFilter = beanFilter;
        return this;
    }

    public MethodParamsCreator withBeanCreator(JavaBeanCreator creator) {
        this.javaBeanCreator = creator;
        return this;
    }

    public MethodParamsCreator withMethod(Method method) {
        this.method = method;
        return this;
    }

    public MethodParamsCreator withExtra(ApiExtra extra) {
        this.extra = extra;
        return this;
    }

    public MethodParamsCreator create() {
        try {
            this.extra.setParameter(null);
            this.extra.setModelClass(null);
            this.extra.setModelName(null);
            this.extra.setReturnType(null);
            this.extra.setStep(ApiCreateStep.Request);
            this.createParameters();
            this.extra.setStep(ApiCreateStep.Response);
            this.createReturnType();
            MockProcess2 mocker = MockProcess2.with(this.mockFilter);
            mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
            Object req = mocker.mockByApiParams(this.requestParameters);
            Object res = mocker.mockByApiParams(this.returnParameter);
            this.requestMock = ObjectUtil.isBaseObject(req) ? req.toString() : JsonUtil.beanToJson(req);
            this.responseMock = ObjectUtil.isBaseObject(res) ? res.toString() : JsonUtil.beanToJson(res);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("\u63a5\u53e3\u53c2\u6570\u6784\u5efa\u5931\u8d25:" + this.clazz.getCanonicalName() + "." + this.method.getName());
        }
    }

    private DocParamEntity createDoc(MethodParam param) {
        Parameter parameter = param.getParameter();
        String paramName = this.reqFilter.parameterName(param.getParamType(), param.getParamName(), this.extra);
        Type paramType = this.reqFilter.parameterType(param.getParamType(), param.getParamName(), this.extra);
        Class ownerClass = GenericTypeUtil.getOwnerClass(paramType);
        this.extra.setModelClass(ownerClass);
        this.extra.setParameter(parameter);
        this.extra.setModelName(paramName);
        if (this.reqFilter.ignore(paramType, ownerClass, this.extra).booleanValue()) {
            return null;
        }
        if (paramType == null || ownerClass == null) {
            return null;
        }
        String description = this.reqFilter.description(paramType, paramName, this.extra);
        if (StringUtil.isEmpty(description)) {
            description = this.extra.getMethodComment().getParameter(paramName).getComment();
        }
        JavaType javaType = JavaType.getJavaTypeByType(paramType);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(description);
        entity.setMockTemplate(this.reqFilter.mockTemplate(paramType, this.extra));
        entity.setName(paramName);
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setRequired(this.reqFilter.required(paramType, this.extra) != false ? 1 : 0);
        entity.setShow(this.reqFilter.show(paramType, this.extra) != false ? 1 : 0);
        entity.setJavaType(javaType.getType());
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(paramType);
        bind.binds(param.getBind());
        this.createParam(paramType, entity, bind);
        return entity;
    }

    private void deepCreateParameters(List<MethodParam> params, List<DocParamEntity> result, String originalParameterName) {
        UncertainParamParser util = null;
        if (this.extra.getMethodComment() != null) {
            util = UncertainParamParser.builder(this.clazz, this.method, this.extra.getControllerComment(), this.extra.getMethodComment());
        }
        for (MethodParam param : params) {
            DocParamEntity createParams = this.createDoc(param);
            if (createParams == null) continue;
            if (CollectionUtils.isEmpty(createParams.getChildren())) {
                result.add(createParams);
                continue;
            }
            if (util != null && originalParameterName != null) {
                for (DocParamEntity doc : createParams.getChildren()) {
                    MethodParam docParam = null;
                    if (doc.getJavaType().equals(JavaType.Map.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestMapField(originalParameterName, doc.getName());
                    }
                    if (doc.getJavaType().equals(JavaType.Object.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestObjField(originalParameterName, doc.getName());
                    }
                    if (docParam == null) continue;
                    if (CollectionUtils.isEmpty(docParam.getChildren())) {
                        DocParamEntity doc1 = this.createDoc(docParam);
                        if (doc1 == null) continue;
                        String name = doc.getName();
                        BeanUtils.copyProperties((Object)doc1, (Object)doc);
                        doc.setName(name);
                        continue;
                    }
                    List children = Optional.ofNullable(param.getChildren()).orElse(new ArrayList());
                    children.addAll(docParam.getChildren());
                    param.setChildren(children);
                }
                result.addAll(createParams.getChildren());
            }
            if (CollectionUtils.isEmpty(param.getChildren())) continue;
            List children = Optional.ofNullable(createParams.getChildren()).orElse(new ArrayList());
            this.deepCreateParameters(param.getChildren(), children, null);
            createParams.setChildren(children);
            if (originalParameterName != null) {
                result.addAll(children);
                continue;
            }
            result.add(createParams);
        }
    }

    private List<MethodParam> createParams(Parameter parameter, Type parameterType, String parameterName) {
        MethodParam param = new MethodParam();
        param.setParamType(parameterType);
        param.setParamName(parameterName);
        Class ownerClass = GenericTypeUtil.getOwnerClass(parameterType);
        UncertainParamParser util = null;
        if (this.extra.getMethodComment() != null) {
            util = UncertainParamParser.builder(this.clazz, this.method, this.extra.getControllerComment(), this.extra.getMethodComment());
        }
        if (Map.class.isAssignableFrom(ownerClass)) {
            if (util == null) {
                return Collections.singletonList(param);
            }
            MethodParam mapParam = util.parseRequestMap(parameterName);
            if (mapParam == null) {
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(mapParam.getChildren()).orElse(Collections.emptyList());
        }
        if (Object.class.equals((Object)ownerClass)) {
            if (util == null) {
                return Collections.singletonList(param);
            }
            MethodParam objParam = util.parseRequestObj(parameterName);
            if (objParam == null) {
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(objParam.getChildren()).orElse(Collections.emptyList());
        }
        return Collections.singletonList(param);
    }

    private void createParameters() {
        Parameter[] parameters = this.method.getParameters();
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discover.getParameterNames(this.method);
        if (parameters == null || parameters.length == 0) {
            return;
        }
        if (parameterNames == null || parameterNames.length == 0) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            MethodParam param = new MethodParam();
            String parameterName = parameterNames[i];
            Type parameterType = parameters[i].getParameterizedType();
            param.setParameter(parameters[i]);
            this.extra.setParameter(parameters[i]);
            parameterName = this.reqFilter.parameterName(parameterType, parameterName, this.extra);
            param.setParamName(parameterName);
            parameterType = this.reqFilter.parameterType(parameterType, parameterName, this.extra);
            param.setParamType(parameterType);
            if (StringUtil.isEmpty(param.getParamName())) {
                param.setParamName(parameterNames[i]);
            }
            ArrayList<DocParamEntity> result = new ArrayList<DocParamEntity>();
            List<MethodParam> params = this.createParams(parameters[i], parameterType, parameterName);
            this.reqFilter.params(params, this.extra);
            this.deepCreateParameters(params, result, parameterNames[i]);
            this.requestParameters.addAll(result);
        }
    }

    private DocParamEntity deepCreateReturnType(MethodParam param) {
        Type type = param.getParamType();
        if (type == Void.TYPE) {
            return null;
        }
        this.extra.setReturnType(type);
        Class ownerClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        bind.binds(param.getBind());
        this.extra.setModelClass(ownerClass);
        this.extra.setModelName(param.getParamName());
        if (type == null || ownerClass == null) {
            return null;
        }
        if (this.resFilter.ignore(type, ownerClass, bind, this.extra).booleanValue()) {
            return null;
        }
        JavaType javaType = JavaType.getJavaTypeByType(type);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(this.resFilter.description(type, this.extra));
        entity.setMockTemplate(this.resFilter.mockTemplate(type, this.extra));
        entity.setRequired(this.resFilter.required(type, ownerClass, bind, this.extra) != false ? 1 : 0);
        entity.setShow(this.resFilter.show(type, ownerClass, bind, this.extra) != false ? 1 : 0);
        entity.setName("_null");
        if (!StringUtil.isEmpty(param.getParamName())) {
            entity.setName(param.getParamName());
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        this.createParam(type, entity, bind);
        entity.setChildren(entity.getChildren() == null ? new ArrayList<DocParamEntity>() : new ArrayList<DocParamEntity>(entity.getChildren()));
        return entity;
    }

    private List<DocParamEntity> mapOrObject(DocParamEntity doc, UncertainParamParser util, boolean isField) {
        if (doc == null) {
            return null;
        }
        if (util != null) {
            List<MethodParam> uncertains = null;
            if (doc.getJavaType().equals(JavaType.Map.getType())) {
                MethodParam mapParam = util.parseResponseMapField(doc.getName());
                if (!isField) {
                    mapParam = util.parseResponseMap();
                }
                if (mapParam != null && mapParam.getChildren() != null) {
                    uncertains = mapParam.getChildren();
                }
            }
            if (!StringUtil.isEmpty(doc.getClassName()) && doc.getClassName().contains("java.lang.Object")) {
                MethodParam objParam = util.parseResponseObjField(doc.getName());
                if (!isField) {
                    objParam = util.parseResponseObj();
                }
                if (objParam != null) {
                    uncertains = objParam.getChildren();
                }
            }
            if (uncertains != null) {
                for (MethodParam uncertain : uncertains) {
                    DocParamEntity childrenDoc = this.createDoc(uncertain);
                    if (childrenDoc == null) continue;
                    ArrayList<DocParamEntity> children = Optional.ofNullable(doc.getChildren()).orElse(new ArrayList());
                    children = new ArrayList<DocParamEntity>(children);
                    children.add(childrenDoc);
                    return children;
                }
            }
        }
        return null;
    }

    private void deepCreateReturnType(List<MethodParam> types, List<DocParamEntity> result) {
        UncertainParamParser util = null;
        if (this.extra.getMethodComment() != null) {
            util = UncertainParamParser.builder(this.clazz, this.method, this.extra.getControllerComment(), this.extra.getMethodComment());
        }
        for (MethodParam param : types) {
            DocParamEntity document = this.deepCreateReturnType(param);
            if (document == null) continue;
            List children = Optional.ofNullable(document.getChildren()).orElse(new ArrayList());
            List<DocParamEntity> mapChildren = this.mapOrObject(document, util, false);
            if (!CollectionUtils.isEmpty(mapChildren)) {
                children.addAll(mapChildren);
            }
            document.setChildren(children);
            for (DocParamEntity doc : children) {
                List<DocParamEntity> docMapChildren = this.mapOrObject(doc, util, true);
                if (CollectionUtils.isEmpty(docMapChildren)) continue;
                ArrayList<DocParamEntity> docChildren = doc.getChildren() == null ? new ArrayList<DocParamEntity>() : new ArrayList<DocParamEntity>(doc.getChildren());
                docChildren.addAll(docMapChildren);
                doc.setChildren(docChildren);
            }
            if (!CollectionUtils.isEmpty(param.getChildren())) {
                ArrayList<DocParamEntity> cr = new ArrayList<DocParamEntity>();
                this.deepCreateReturnType(param.getChildren(), cr);
                children.addAll(cr);
            }
            document.setChildren(children);
            result.add(document);
        }
    }

    private void createReturnType() {
        MethodParam param;
        List<MethodParam> types = this.resFilter.returnTypes(this.method, this.extra);
        if (types == null) {
            return;
        }
        if (!(types.size() != 1 || CollectionUtils.isEmpty(ProjectContext.globalParams) || StringUtil.isEmpty(ProjectContext.globalFieldName) || ProjectContext.globalResponseClass.equals(GenericTypeUtil.getOwnerClass((param = types.get(0)).getParamType())))) {
            param.setParamName(ProjectContext.globalFieldName);
            List<MethodParam> globalParams = ProjectContext.globalParams;
            Set<String> ignores = ProjectContext.globalResponseIgnoreFieldNames;
            ignores.add(ProjectContext.globalFieldName);
            ignores.add("serialVersionUID");
            globalParams.removeIf(next -> ignores.contains(next.getParamName()));
            globalParams.add(param);
            types = globalParams;
        }
        this.extra.setMethod(this.method);
        ArrayList<DocParamEntity> result = new ArrayList<DocParamEntity>();
        this.deepCreateReturnType(types, result);
        if (result.isEmpty()) {
            return;
        }
        if (result.size() == 1) {
            if (JavaType.isBaseType(((DocParamEntity)result.get(0)).getJavaType())) {
                this.returnParameter.addAll(result);
            } else {
                this.returnParameter.addAll(((DocParamEntity)result.get(0)).getChildren());
            }
        } else {
            this.returnParameter.addAll(result);
        }
    }

    private void createParam(Type type, DocParamEntity entity, GenericTypeBind bind) {
        JavaType javaType = JavaType.getType(entity.getJavaType());
        HashMap<String, List<DocParamEntity>> exists = new HashMap<String, List<DocParamEntity>>();
        if (javaType == JavaType.Object) {
            entity.setChildren(this.javaBeanCreator.readBean(type, bind, exists));
            return;
        }
        Class ownerClass = GenericTypeUtil.getOwnerClass(type);
        if (ownerClass == null) {
            return;
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType) {
            case Array: {
                entity.setChildren(this.javaBeanCreator.readArray(type, bind));
                break;
            }
            case ArrayObject: {
                entity.setChildren(this.javaBeanCreator.readArrayObject(type, bind, exists));
            }
        }
        Object mockValue = this.mockFilter.mock(entity.getMockTemplate(), javaType);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        String uniqueStr = this.extra.getControllerClass().getCanonicalName() + this.extra.getMethod().toGenericString() + entity.getClassName() + entity.getName();
        entity.setUnique(StringUtil.toMD5(uniqueStr));
        entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
        RenewType renewType = this.javaBeanApiFilter.renewType(this.extra.getModelClass(), bind, this.extra);
        entity.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
    }

    public List<DocParamEntity> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return this.returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return this.responseMock;
    }

    public String getRequestMock() {
        return this.requestMock;
    }
}

