/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.javadoc.util;

import cn.easyutil.easyapi.javadoc.util.BaseClassEnum;
import cn.easyutil.easyapi.javadoc.util.CommentStringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.DefaultParameterNameDiscoverer;

public class CommentTypeUtil {
    public static Class<?> getMethodReturnClass(String methodName, Class<?> clazz) {
        for (Class<?> c = clazz; c != null && !c.equals(Object.class); c = c.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = c.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method.getReturnType();
            }
        }
        return null;
    }

    public static Object getFieldDefaultValue(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            Object val = field.get(clazz.newInstance());
            field.setAccessible(false);
            modifiersField.setAccessible(false);
            return val;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static String getMapKeyName(String quoteName, Class<?> clazz, List<String> sourceLines, List<String> imports) {
        String key = null;
        if (quoteName.contains("\"")) {
            key = quoteName.replace("\"", "");
        } else {
            ArrayList<String> nexts = new ArrayList<String>(Arrays.asList(quoteName.split("\\.")));
            String className = (String)nexts.get(0);
            if (nexts.size() == 1) {
                Object fieldDefaultValue = CommentTypeUtil.getFieldDefaultValue(clazz, className);
                if (fieldDefaultValue == null) {
                    String s = sourceLines.stream().filter(str -> CommentStringUtil.isAssignLine(className, str)).findFirst().orElse(null);
                    if (s == null) {
                        return null;
                    }
                    key = s.split("=")[1].replace("\"", "").replace(";", "").trim();
                } else {
                    key = fieldDefaultValue.toString();
                }
            } else {
                Class<?> aClass = CommentTypeUtil.findSimpleNameClass(className, clazz, sourceLines, imports);
                if (aClass == null) {
                    return null;
                }
                nexts.remove(0);
                for (String next : nexts) {
                    Object fieldDefaultValue = CommentTypeUtil.getFieldDefaultValue(aClass, next);
                    if (fieldDefaultValue == null) {
                        return null;
                    }
                    key = fieldDefaultValue.toString();
                }
            }
        }
        if (key != null) {
            key = key.replace("(", "").replace(")", "").replace(";", "").replace(",", "").replace(".", "").trim();
        }
        return key;
    }

    public static Class<?> findSimpleNameClass(String className, Class<?> clazz, List<String> sourceLines, List<String> imports) {
        for (String sourceLine : sourceLines) {
            if (!CommentStringUtil.isVariableLine(className, sourceLine) || !sourceLine.contains(";")) continue;
            Object pre = null;
            pre = sourceLine.contains("=") ? sourceLine.substring(0, sourceLine.indexOf("=")).replace("final", "").trim() : sourceLine.replace(";", "").replace("final", "").trim();
            if (!CommentStringUtil.isVariableLine(className, (String)pre)) continue;
            if (((String)pre).contains("<") && ((String)pre).contains(">")) {
                String s = ((String)pre).substring(0, ((String)pre).indexOf("<"));
                String e = ((String)pre).substring(((String)pre).lastIndexOf(">") + 1);
                pre = s + e;
            }
            if (((String)pre).split(" ").length != 2 || !((String)pre).split(" ")[1].equals(className)) continue;
            className = ((String)pre).split(" ")[0];
        }
        String packageName = null;
        String importName = null;
        for (String anImport : imports) {
            String str = anImport.trim().replace(";", "");
            if (str.startsWith("package")) {
                packageName = str.substring(str.indexOf("package") + 7).trim();
            }
            if (!anImport.trim().startsWith("import") || !anImport.replace(";", "").trim().endsWith(className)) continue;
            importName = anImport.replace("import", "").replace(";", "").trim();
            break;
        }
        if (importName != null) {
            try {
                return Class.forName(importName);
            }
            catch (ClassNotFoundException pre) {
                // empty catch block
            }
        }
        if (packageName != null) {
            try {
                return Class.forName(packageName + "." + className);
            }
            catch (ClassNotFoundException pre) {
                // empty catch block
            }
        }
        try {
            return clazz.getDeclaredField(className).getType();
        }
        catch (Exception pre) {
            Class<?> type = BaseClassEnum.getType(className);
            if (type != null) {
                return type;
            }
            if (className.equals("true") || className.equals("false")) {
                return Boolean.class;
            }
            try {
                Double.valueOf(className);
                return Double.class;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static Class<?> findVariableClassByReflection(String variableName, Class<?> clazz, Method method) {
        try {
            return clazz.getDeclaredField(variableName).getType();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
            String[] parameterNames = discover.getParameterNames(method);
            if (parameterNames == null) {
                return null;
            }
            for (int i = 0; i < parameterNames.length; ++i) {
                if (!parameterNames[i].equals(variableName)) continue;
                return method.getParameters()[i].getType();
            }
            return null;
        }
    }

    public Class<?> findVariableClassByComment(String variableName, List<String> sourceLines, List<String> importLines) {
        return null;
    }

    public static Class<?> findQuoteClass(String quoteName, List<String> sourceLines, List<String> importLines, Class<?> clazz) {
        String[] split = quoteName.split("\\.");
        String quote = split[0];
        Class<Object> quoteClass = null;
        if (quote.contains("new")) {
            String newStr = quote.replace("new", "").trim();
            quote = newStr.substring(0, newStr.indexOf("("));
        }
        if (!quote.contains("(") && !quote.contains(")")) {
            quoteClass = CommentTypeUtil.findSimpleNameClass(quote, clazz, sourceLines, importLines);
            if (split.length == 1) {
                if (quoteClass == null) {
                    quoteClass = String.class;
                }
                return quoteClass;
            }
            if (quoteClass == null) {
                return null;
            }
        } else {
            String methodName = quote.substring(0, quote.indexOf("("));
            quoteClass = CommentTypeUtil.getMethodReturnClass(methodName, clazz);
        }
        if (quoteClass == null) {
            return null;
        }
        ArrayList<String> methods = new ArrayList<String>(Arrays.asList(split));
        methods.remove(0);
        for (String method : methods) {
            if (!method.contains("(")) {
                try {
                    quoteClass = quoteClass.getDeclaredField(method).getType();
                    continue;
                }
                catch (Exception e) {
                    return null;
                }
            }
            String methodName = method.substring(0, method.indexOf("("));
            quoteClass = CommentTypeUtil.getMethodReturnClass(methodName, quoteClass);
        }
        return quoteClass;
    }
}

