/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.filter.readBean.model;

import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ApidocCommentUtil;
import cn.easyutil.easyapi.filter.readBean.ReadBeanIgnore;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BeanIgnoreCommentReader
implements ReadBeanIgnore {
    @Override
    public Boolean ignore(Type type, GenericTypeBind bind, ApiExtra extra) {
        if (extra.getModelField() == null) {
            return false;
        }
        Field field = extra.getModelField();
        if (type.equals(Serializable.class) || type.equals(HttpServletRequest.class) || type.equals(HttpServletResponse.class)) {
            return true;
        }
        if (field.getName().equals("serialVersionUID")) {
            return true;
        }
        String typeName = type.getTypeName();
        if (typeName.startsWith("sun.")) {
            return true;
        }
        if (type.equals(Class.class)) {
            return true;
        }
        if (extra.getFieldComment() != null && !StringUtil.isEmpty(extra.getFieldComment().getComment())) {
            String groups = ApidocCommentUtil.getCommentValue(extra.getFieldComment().getComment(), "groups");
            if (StringUtil.isEmpty(groups) || !groups.startsWith("[") || !groups.endsWith("]")) {
                return false;
            }
            String[] s = groups.substring(1, groups.length() - 1).split(",");
            String path = extra.getControllerClass().getCanonicalName() + "." + extra.getMethod().getName();
            return Stream.of(s).noneMatch(group -> ApidocCommentUtil.isMatchPath(group, path));
        }
        return false;
    }
}

